/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

class UnmonitorCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    UnmonitorCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        CommandSender sender = data.sender();
        int length = data.args().length;
        String[] args = data.args();
        if (this.checkArgCountAndNotify(sender, length)) {
            return;
        }
        Channel channel = this.getChannel(sender, args[0]);
        if (channel == null) {
            return;
        }
        Monitorable monitorable = this.getMonitorable(sender, channel);
        if (monitorable == null) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isNotMonitoring(sender, target, monitorable)) {
            return;
        }
        target.unmonitor(monitorable);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private boolean isNotMonitoring(@NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Monitorable monitorable) {
        return this.checkConditionAndNotify(!target.isMonitoring(monitorable), sender, target, monitorable, Message.NOT_MONITORING, Message.NOT_MONITORING_OTHER);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.UNMONITORED, Message.UNMONITORED_OTHER);
    }
}

