/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.channel;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.commands.base.OneToTwoArgAbstractCommand;
import com.pedestriamc.strings.user.User;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

class UnmuteCommand
extends OneToTwoArgAbstractCommand
implements CartCommandExecutor {
    UnmuteCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Override
    public void onCommand(@NotNull CommandData data) {
        String[] args;
        CommandSender sender = data.sender();
        if (this.checkArgCountAndNotify(sender, (args = data.args()).length)) {
            return;
        }
        Channel channel = this.getChannel(sender, args[0]);
        if (channel == null) {
            return;
        }
        User target = this.getTarget(sender, args);
        if (target == null) {
            return;
        }
        if (this.isNotMuted(sender, target, channel)) {
            return;
        }
        target.unmuteChannel(channel);
        this.saveUser(target);
        this.sendFinalMessages(sender, target, channel);
    }

    private void sendFinalMessages(@NotNull CommandSender sender, @NotNull User target, @NotNull Channel channel) {
        this.sendAlternateMessages(sender, target, channel, Message.UNMUTE_SUCCESS, Message.UNMUTE_SUCCESS_OTHER);
    }

    private boolean isNotMuted(@NotNull CommandSender sender, @NotNull StringsUser target, @NotNull Channel channel) {
        return this.checkConditionAndNotify(!target.hasChannelMuted(channel), sender, target, channel, Message.NOT_MUTED, Message.NOT_MUTED_OTHER);
    }
}

