/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.ignore;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.commands.AbstractCommand;
import com.pedestriamc.strings.user.User;
import java.util.Map;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractIgnoreCommand
extends AbstractCommand {
    protected AbstractIgnoreCommand(@NotNull Strings strings) {
        super(strings);
    }

    @Nullable
    protected User getIgnoreTarget(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 0) {
            this.strings().getLogger().warning("Getting ignore target failed");
            return null;
        }
        String targetName = args[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            this.sendMessage(Message.UNKNOWN_PLAYER, Map.of("{player}", targetName), sender);
            return null;
        }
        return this.getUser(target);
    }

    protected boolean checkArgCountAndNotify(@NotNull CommandSender sender, int length) {
        return switch (length) {
            case 0 -> {
                this.sendMessage(Message.INSUFFICIENT_ARGS, sender);
                yield true;
            }
            case 1 -> {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("[Strings] You must define a player to use this command on.");
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.ignore.*", "strings.chat.ignore.other")) {
                    yield false;
                }
                this.sendMessage(Message.NO_PERMS_MODIFY_OTHER, sender);
                yield true;
            }
            default -> {
                this.sendMessage(Message.TOO_MANY_ARGS, sender);
                yield true;
            }
        };
    }

    @Nullable
    protected User getTarget(@NotNull CommandSender sender, @NotNull String[] args) {
        if (args.length == 1) {
            if (sender instanceof Player) {
                Player playerSender = (Player)sender;
                return this.getUser(playerSender);
            }
            throw new ClassCastException("If args length is 1, the sender must be a player.");
        }
        if (args.length == 2) {
            String playerName = args[0];
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                this.sendMessage(Message.INVALID_PLAYER, Map.of("{player}", playerName), sender);
                return null;
            }
            return this.getUser(player);
        }
        return null;
    }
}

