/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.ignore;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.message.Messageable;
import com.pedestriamc.strings.commands.ignore.AbstractIgnoreCommand;
import com.pedestriamc.strings.user.User;
import java.util.Map;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class IgnoreCommand
extends AbstractIgnoreCommand
implements CommandExecutor {
    public IgnoreCommand(@NotNull Strings strings) {
        super(strings);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (this.doesNotHavePermission(sender)) {
            return true;
        }
        if (this.checkArgCountAndNotify(sender, args.length)) {
            return true;
        }
        User ignorer = this.getTarget(sender, args);
        if (ignorer == null) {
            return true;
        }
        User target = this.getIgnoreTarget(sender, args);
        if (target == null) {
            return true;
        }
        if (this.attemptingToIgnoreSelf(sender, ignorer, target)) {
            return true;
        }
        if (this.alreadyIgnored(sender, ignorer, target)) {
            return true;
        }
        if (this.cannotIgnore(sender, target)) {
            return true;
        }
        ignorer.ignore(target);
        this.saveUser(ignorer);
        Map<String, String> placeholders = Map.of("{player}", ignorer.getName(), "{target}", target.getName());
        if (!sender.equals((Object)ignorer.player())) {
            this.sendMessage(Message.PLAYER_IGNORED_OTHER, placeholders, sender);
        }
        this.messenger().sendMessage(Message.PLAYER_IGNORED, (Messageable)ignorer, placeholders);
        return true;
    }

    private boolean doesNotHavePermission(@NotNull CommandSender sender) {
        if (!Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.ignore")) {
            this.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        return false;
    }

    private boolean alreadyIgnored(@NotNull CommandSender sender, @NotNull User ignorer, @NotNull User ignored) {
        if (ignorer.isIgnoring(ignored)) {
            this.sendMessage(Message.ALREADY_IGNORED, Map.of("{player}", ignored.getName()), sender);
            return true;
        }
        return false;
    }

    private boolean attemptingToIgnoreSelf(@NotNull CommandSender sender, @NotNull User ignorer, @NotNull User target) {
        if (ignorer.equals(target)) {
            if (sender.equals((Object)ignorer.player())) {
                this.sendMessage(Message.CANT_IGNORE_SELF, sender);
            } else {
                this.sendMessage(Message.CANT_IGNORE_SELF_OTHER, sender);
            }
            return true;
        }
        return false;
    }

    private boolean cannotIgnore(@NotNull CommandSender sender, @NotNull User target) {
        boolean ignorable;
        if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.chat.*", "strings.chat.bypass-unignorable")) {
            return false;
        }
        boolean bl = ignorable = !Permissions.anyOfOrAdmin((Permissible)target.player(), "strings.*", "strings.chat.*", "strings.chat.unignorable");
        if (ignorable) {
            return false;
        }
        this.sendMessage(Message.CANT_IGNORE, Map.of("{player}", target.getName()), sender);
        return true;
    }
}

