/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.ignore;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.message.Messageable;
import com.pedestriamc.strings.commands.ignore.AbstractIgnoreCommand;
import com.pedestriamc.strings.user.User;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class UnIgnoreCommand
extends AbstractIgnoreCommand
implements CommandExecutor {
    public UnIgnoreCommand(@NotNull Strings strings) {
        super(strings);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (this.checkArgCountAndNotify(sender, args.length)) {
            return true;
        }
        User ignorer = this.getTarget(sender, args);
        if (ignorer == null) {
            return true;
        }
        User target = this.getIgnoreTarget(sender, args);
        if (target == null) {
            return true;
        }
        if (this.notIgnoring(sender, ignorer, target)) {
            return true;
        }
        ignorer.stopIgnoring(target);
        this.saveUser(ignorer);
        Map<String, String> placeholders = Map.of("{player}", ignorer.getName(), "{target}", target.getName());
        if (!sender.equals((Object)ignorer.player())) {
            this.sendMessage(Message.PLAYER_UNIGNORED_OTHER, placeholders, sender);
        }
        this.messenger().sendMessage(Message.PLAYER_UNIGNORED, (Messageable)ignorer, placeholders);
        return true;
    }

    private boolean notIgnoring(@NotNull CommandSender sender, @NotNull User ignorer, @NotNull User target) {
        if (!ignorer.isIgnoring(target)) {
            this.sendMessage(Message.NOT_IGNORED, Map.of("{player}", target.getName()), sender);
            return true;
        }
        return false;
    }
}

