/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.message;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.directmessage.PlayerDirectMessenger;
import com.pedestriamc.strings.impl.BukkitMessenger;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class DirectMessageCommand
implements CommandExecutor {
    private final PlayerDirectMessenger playerDirectMessenger;
    private final BukkitMessenger messenger;

    public DirectMessageCommand(@NotNull Strings strings) {
        this.playerDirectMessenger = strings.getPlayerDirectMessenger();
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] This command can only be used by players!");
            return true;
        }
        if (!(sender.hasPermission("strings.chat.msg") || sender.hasPermission("strings.chat.*") || sender.hasPermission("strings.*"))) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        if (args.length < 2) {
            this.messenger.sendMessage(Message.INSUFFICIENT_ARGS, sender);
            return true;
        }
        Player recipient = Bukkit.getPlayer((String)args[0]);
        if (recipient == null) {
            this.messenger.sendMessage(Message.UNKNOWN_PLAYER, sender);
            return true;
        }
        if (recipient.equals((Object)sender)) {
            this.messenger.sendMessage(Message.SELF_MESSAGE, sender);
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            stringBuilder.append(args[i]);
            stringBuilder.append(" ");
        }
        this.playerDirectMessenger.sendMessage((Player)sender, recipient, stringBuilder.toString());
        return true;
    }
}

