/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.commands.message;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.directmessage.PlayerDirectMessenger;
import com.pedestriamc.strings.impl.BukkitMessenger;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class ReplyCommand
implements CommandExecutor {
    private final PlayerDirectMessenger playerDirectMessenger;
    private final BukkitMessenger messenger;

    public ReplyCommand(@NotNull Strings strings) {
        this.playerDirectMessenger = strings.getPlayerDirectMessenger();
        this.messenger = strings.getMessenger();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length < 1) {
            this.messenger.sendMessage(Message.INSUFFICIENT_ARGS, sender);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("[Strings] This command can only be used by players!");
            return true;
        }
        if (!(sender.hasPermission("strings.chat.msg") || sender.hasPermission("strings.chat.*") || sender.hasPermission("strings.*"))) {
            this.messenger.sendMessage(Message.NO_PERMS, sender);
            return true;
        }
        StringBuilder message = new StringBuilder();
        for (String arg : args) {
            message.append(arg);
            message.append(" ");
        }
        this.playerDirectMessenger.reply((Player)sender, message.toString().trim());
        return true;
    }
}

