/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.configuration;

import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.api.settings.Settings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class Configuration
implements Settings {
    private final EnumMap<Option.Text, String> stringMap = new EnumMap(Option.Text.class);
    private final EnumMap<Option.Bool, Boolean> booleans = new EnumMap(Option.Bool.class);
    private final EnumMap<Option.Double, Double> doubles = new EnumMap(Option.Double.class);
    private final EnumMap<Option.StringList, List<String>> lists = new EnumMap(Option.StringList.class);

    public Configuration(@NotNull FileConfiguration config) {
        this.loadStrings(config);
        this.loadDoubles(config);
        this.loadBooleans(config);
        this.loadStringLists(config);
    }

    private void loadStrings(@NotNull FileConfiguration config) {
        for (Option.Text option : Option.Text.values()) {
            String val = config.getString(option.getKey());
            if (val != null) {
                this.stringMap.put(option, val);
                continue;
            }
            this.stringMap.put(option, option.getDefault());
        }
    }

    private void loadBooleans(@NotNull FileConfiguration config) {
        for (Option.Bool bool : Option.Bool.values()) {
            String key = bool.getKey();
            if (config.contains(key)) {
                this.booleans.put(bool, config.getBoolean(key));
                continue;
            }
            this.booleans.put(bool, bool.getDefault());
        }
    }

    private void loadDoubles(@NotNull FileConfiguration config) {
        for (Option.Double option : Option.Double.values()) {
            String key = option.getKey();
            if (config.contains(key)) {
                this.doubles.put(option, config.getDouble(key));
                continue;
            }
            this.doubles.put(option, option.getDefault());
        }
    }

    private void loadStringLists(@NotNull FileConfiguration config) {
        for (Option.StringList list : Option.StringList.values()) {
            String key = list.getKey();
            if (config.contains(key)) {
                this.lists.put(list, config.getStringList(key));
                continue;
            }
            this.lists.put(list, list.getDefault());
        }
    }

    @Override
    @NotNull
    public String getString( @NotNull Option.Text option) {
        return this.stringMap.get((Object)option);
    }

    @Override
    @NotNull
    public String getColored( @NotNull Option.Text option) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getString(option));
    }

    @Override
    @NotNull
    public List<String> getStringList( @NotNull Option.StringList option) {
        return new ArrayList<String>((Collection)this.lists.get((Object)option));
    }

    @Override
    public boolean getBoolean( @NotNull Option.Bool option) {
        return this.booleans.get((Object)option);
    }

    @Override
    public double getDouble( @NotNull Option.Double option) {
        return this.doubles.get((Object)option);
    }

    @Override
    public float getFloat( @NotNull Option.Double option) {
        return (float)this.getDouble(option);
    }
}

