/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.deathmessages;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.deathmessages.DeathMessageProvider;
import com.pedestriamc.strings.deathmessages.PlaceholderGenerator;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class DeathMessageManager {
    private final DeathMessageProvider registry;
    private final UserUtil userUtil;

    public DeathMessageManager(@NotNull Strings strings) {
        this.registry = new DeathMessageProvider(strings);
        this.userUtil = strings.users();
    }

    @NotNull
    public String getDeathMessage(@NotNull Player deceased, @NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent event) {
        Map<String, String> fighterPlaceholders = this.getFighterPlaceholders(deceased);
        String message = !fighterPlaceholders.isEmpty() ? this.registry.randomEscapingMessage(cause) : this.registry.randomMessage(cause);
        Map<String, String> placeholders = this.generateDeceasedPlaceholders(deceased);
        placeholders.putAll(PlaceholderGenerator.generate(cause, event));
        placeholders.putAll(fighterPlaceholders);
        message = this.replacePlaceholders(message, placeholders);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    @NotNull
    private Map<String, String> generateDeceasedPlaceholders(@NotNull Player deceased) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("{player}", deceased.getName());
        placeholders.put("{display-name}", deceased.getDisplayName());
        return placeholders;
    }

    @NotNull
    private @Unmodifiable Map<String, String> getFighterPlaceholders(@NotNull Player deceased) {
        User user = this.userUtil.getUser(deceased);
        EntityDamageEvent event = user.getSecondToLastDamage();
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageByEntityEvent = (EntityDamageByEntityEvent)event;
            Entity damager = damageByEntityEvent.getDamager();
            if (damager instanceof Player) {
                Player player = (Player)damager;
                return Map.of("{fighter}", player.getName(), "{fighter-display-name}", player.getDisplayName());
            }
            if (damager instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)damager;
                String customName = livingEntity.getCustomName();
                String mob = customName != null ? customName : livingEntity.getName();
                return Map.of("{fighter}", mob, "{fighter-display-name}", mob);
            }
        }
        return Map.of();
    }

    @NotNull
    private String replacePlaceholders(@NotNull String string, @NotNull Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            string = string.replace(entry.getKey(), entry.getValue());
        }
        return string;
    }
}

