/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.deathmessages;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.deathmessages.DeathMessageKeys;
import java.time.LocalDateTime;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.entity.EntityDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathMessageProvider {
    private static final Random RANDOM = new Random(44833L * (long)LocalDateTime.now().getNano());
    private static final String FALLBACK_DEATH_MESSAGE = "&f{player} died";
    private final Map<EntityDamageEvent.DamageCause, DeathMessageEntry> messages;

    DeathMessageProvider(@NotNull Strings strings) {
        FileConfiguration config = strings.files().getDeathMessagesFileConfig();
        EnumMap<EntityDamageEvent.DamageCause, DeathMessageEntry> map = new EnumMap<EntityDamageEvent.DamageCause, DeathMessageEntry>(EntityDamageEvent.DamageCause.class);
        for (Map.Entry<EntityDamageEvent.DamageCause, String> entry : DeathMessageKeys.KEYS.entrySet()) {
            List standard = config.getStringList(entry.getValue());
            List escaping = config.getStringList(entry.getValue() + "-escaping");
            map.put(entry.getKey(), new DeathMessageEntry(standard, escaping));
        }
        this.messages = map;
    }

    @NotNull
    public String randomMessage(@NotNull EntityDamageEvent.DamageCause cause) {
        DeathMessageEntry entry = this.messages.get(cause);
        if (entry != null) {
            return entry.randomStandardMessage();
        }
        return FALLBACK_DEATH_MESSAGE;
    }

    @NotNull
    public String randomEscapingMessage(@NotNull EntityDamageEvent.DamageCause cause) {
        DeathMessageEntry entry = this.messages.get(cause);
        if (entry != null) {
            return entry.randomEscapingMessage();
        }
        return FALLBACK_DEATH_MESSAGE;
    }

    private record DeathMessageEntry(@NotNull List<String> standardMessages, @NotNull List<String> escapingMessages) {
        @NotNull
        String randomStandardMessage() {
            String message = this.randomMessageFromList(this.standardMessages);
            return message != null ? message : DeathMessageProvider.FALLBACK_DEATH_MESSAGE;
        }

        @NotNull
        String randomEscapingMessage() {
            String message = this.randomMessageFromList(this.escapingMessages);
            return message != null ? message : this.randomStandardMessage();
        }

        @Nullable
        private String randomMessageFromList(@NotNull List<String> list) {
            return switch (list.size()) {
                case 0 -> null;
                case 1 -> list.getFirst();
                default -> list.get(RANDOM.nextInt(list.size()));
            };
        }
    }
}

