/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.deathmessages;

import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.block.Block;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

final class PlaceholderGenerator {
    private static final String UNKNOWN = "unknown";

    private PlaceholderGenerator() {
    }

    @NotNull
    static Map<String, String> generate(@NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent finalDamage) {
        return switch (cause) {
            case EntityDamageEvent.DamageCause.CONTACT -> PlaceholderGenerator.getContactPlaceholders(cause, finalDamage);
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK, EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK, EntityDamageEvent.DamageCause.THORNS -> PlaceholderGenerator.getAttackPlaceholders(cause, finalDamage);
            case EntityDamageEvent.DamageCause.PROJECTILE -> PlaceholderGenerator.getProjectilePlaceholders(cause, finalDamage);
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> PlaceholderGenerator.getExplosionPlaceholders(cause, finalDamage);
            default -> Map.of();
        };
    }

    @NotNull
    static @Unmodifiable Map<String, String> getContactPlaceholders(@NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent finalDamage) {
        EntityDamageByBlockEvent blockEvent;
        Block block;
        String blockName = UNKNOWN;
        if (finalDamage instanceof EntityDamageByBlockEvent && (block = (blockEvent = (EntityDamageByBlockEvent)finalDamage).getDamager()) != null) {
            blockName = block.getType().name().toLowerCase(Locale.ROOT).replace("_", " ");
        }
        return Map.of("{block}", blockName);
    }

    @NotNull
    static @Unmodifiable Map<String, String> getAttackPlaceholders(@NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent finalDamage) {
        String killerName = UNKNOWN;
        String killerDisplayName = UNKNOWN;
        if (finalDamage instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)finalDamage;
            Entity entity = entityEvent.getDamager();
            if (entity instanceof Player) {
                Player p = (Player)entity;
                killerName = p.getName();
                killerDisplayName = p.getDisplayName();
            } else {
                String customName = entity.getCustomName();
                killerDisplayName = killerName = customName != null ? customName : entity.getName();
            }
        }
        return Map.of("{killer}", killerName, "{killer-display-name}", killerDisplayName);
    }

    @NotNull
    static @Unmodifiable Map<String, String> getProjectilePlaceholders(@NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent finalDamage) {
        String killerName = UNKNOWN;
        String killerDisplayName = UNKNOWN;
        if (finalDamage instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)finalDamage;
            Entity entity = entityEvent.getDamager();
            if (entity instanceof Projectile) {
                Projectile proj = (Projectile)entity;
                ProjectileSource source = proj.getShooter();
                if (source instanceof Player) {
                    Player p = (Player)source;
                    killerName = p.getName();
                    killerDisplayName = p.getDisplayName();
                } else if (source instanceof LivingEntity) {
                    LivingEntity e = (LivingEntity)source;
                    String customName = e.getCustomName();
                    killerDisplayName = killerName = customName != null ? customName : e.getName();
                }
            } else {
                String customName = entity.getCustomName();
                killerDisplayName = killerName = customName != null ? customName : entity.getName();
            }
        }
        return Map.of("{killer}", killerName, "{killer-display-name}", killerDisplayName);
    }

    @NotNull
    static @Unmodifiable Map<String, String> getExplosionPlaceholders(@NotNull EntityDamageEvent.DamageCause cause, @NotNull EntityDamageEvent finalDamage) {
        String killerName = UNKNOWN;
        if (finalDamage instanceof EntityDamageByEntityEvent) {
            Entity damager;
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)finalDamage;
            Entity entity = damager = entityEvent.getDamager();
            Objects.requireNonNull(entity);
            Entity entity2 = entity;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TNTPrimed.class, Firework.class, ExplosiveMinecart.class, WitherSkull.class, DragonFireball.class, Fireball.class, LivingEntity.class}, (Object)entity2, n)) {
                case 0: {
                    TNTPrimed tntPrimed = (TNTPrimed)entity2;
                    killerName = "TNT";
                    break;
                }
                case 1: {
                    Firework firework = (Firework)entity2;
                    killerName = "Firework";
                    break;
                }
                case 2: {
                    ExplosiveMinecart cart = (ExplosiveMinecart)entity2;
                    killerName = "TNT Minecart";
                    break;
                }
                case 3: {
                    WitherSkull skull = (WitherSkull)entity2;
                    killerName = "Wither Skull";
                    break;
                }
                case 4: {
                    DragonFireball dragonBall = (DragonFireball)entity2;
                    killerName = "Dragon Fireball";
                    break;
                }
                case 5: {
                    Fireball ball = (Fireball)entity2;
                    killerName = "Fireball";
                    break;
                }
                case 6: {
                    LivingEntity livingEntity = (LivingEntity)entity2;
                    String customName = livingEntity.getCustomName();
                    killerName = customName != null ? customName : livingEntity.getName();
                    break;
                }
            }
        }
        return Map.of("{killer}", killerName);
    }
}

