/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.directmessage;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.event.moderation.PlayerDirectMessageEvent;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.impl.BukkitMessenger;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class PlayerDirectMessenger {
    @NotNull
    private final Strings strings;
    @NotNull
    private final UserUtil userUtil;
    @NotNull
    private final BukkitMessenger messenger;
    @NotNull
    private final Map<Player, Player> replyList = new ConcurrentHashMap<Player, Player>();
    @NotNull
    private final String messageFormatSender;
    @NotNull
    private final String messageFormatRecipient;
    private final boolean usePAPI;

    public PlayerDirectMessenger(@NotNull Strings strings) {
        this.strings = strings;
        this.userUtil = strings.users();
        Configuration config = strings.getConfiguration();
        this.messageFormatSender = config.getString(Option.Text.DIRECT_MESSAGE_FORMAT_OUT);
        this.messageFormatRecipient = config.getString(Option.Text.DIRECT_MESSAGE_FORMAT_IN);
        this.usePAPI = strings.isUsingPlaceholderAPI();
        this.messenger = strings.getMessenger();
    }

    public void reply(@NotNull Player sender, @NotNull String message) {
        Player recipient = this.replyList.get(sender);
        if (recipient == null) {
            this.messenger.sendMessage(Message.NO_REPLY, (CommandSender)sender);
            return;
        }
        if (!recipient.isOnline()) {
            this.messenger.sendMessage(Message.PLAYER_OFFLINE, (CommandSender)sender);
            return;
        }
        this.sendMessage(sender, this.replyList.get(sender), message);
    }

    public void sendMessage(@NotNull Player sender, @NotNull Player recipient, @NotNull String message) {
        String senderString = this.processPlaceholders(sender, recipient, this.messageFormatSender).replace("{message}", message);
        String recipientString = this.processPlaceholders(sender, recipient, this.messageFormatRecipient).replace("{message}", message);
        if (this.usePAPI) {
            try {
                senderString = PlaceholderAPI.setPlaceholders((Player)recipient, (String)senderString);
                recipientString = PlaceholderAPI.setPlaceholders((Player)sender, (String)recipientString);
            }
            catch (Exception ex) {
                this.strings.warning("An error occurred while handling a /msg command.");
                this.strings.warning(ex.getMessage());
            }
        }
        senderString = this.color(senderString);
        recipientString = this.color(recipientString);
        boolean ignored = this.isRecipientIgnoring(sender, recipient);
        PlayerDirectMessageEvent event = new PlayerDirectMessageEvent(sender, recipient, message, ignored);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            sender.sendMessage(senderString);
            this.replyList.put(recipient, sender);
            if (!ignored) {
                recipient.sendMessage(recipientString);
            }
        }
    }

    public String processPlaceholders(@NotNull Player sender, @NotNull Player recipient, @NotNull String message) {
        User senderUser = this.userUtil.getUser(sender);
        User recipientUser = this.userUtil.getUser(recipient);
        message = message.replace("{sender_username}", sender.getName()).replace("{sender_displayname}", sender.getDisplayName()).replace("{sender_prefix}", senderUser.getPrefix()).replace("{sender_suffix}", senderUser.getSuffix()).replace("{recipient_username}", recipient.getName()).replace("{recipient_displayname}", recipient.getDisplayName()).replace("{recipient_prefix}", recipientUser.getPrefix()).replace("{recipient_suffix}", recipientUser.getSuffix());
        return message;
    }

    @NotNull
    private String color(@NotNull String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    private boolean isRecipientIgnoring(@NotNull Player sender, @NotNull Player recipient) {
        return this.userUtil.getUser(recipient).getIgnoredPlayers().contains(sender.getUniqueId());
    }
}

