/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.impl;

import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.message.MessageContext;
import com.pedestriamc.strings.api.message.Messageable;
import com.pedestriamc.strings.api.message.Messenger;
import com.pedestriamc.strings.impl.MessageableAdapter;
import java.util.EnumMap;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class BukkitMessenger
implements Messenger {
    private final EnumMap<Message, Object> enumMap = new EnumMap(Message.class);
    private final String prefix;

    public BukkitMessenger(FileConfiguration config) {
        for (Message msg : Message.values()) {
            String key = msg.getKey();
            try {
                if (config.isList(key)) {
                    this.enumMap.put(msg, (Object)config.getStringList(key).toArray(new String[0]));
                    continue;
                }
                this.enumMap.put(msg, (Object)config.getString(key));
            }
            catch (NullPointerException e) {
                Bukkit.getLogger().warning("[Strings] Unable to find message for " + String.valueOf((Object)msg));
            }
        }
        this.prefix = config.getString("prefix", "&8[&3Strings&8] &f");
    }

    public void sendMessage(Message message, CommandSender recipient) {
        this.sendMessage(message, MessageableAdapter.of(recipient));
    }

    public void sendMessage(Message message, Map<String, String> placeholders, CommandSender recipient) {
        this.sendMessage(message, MessageableAdapter.of(recipient), placeholders);
    }

    @Override
    public void sendMessage(@NotNull Message message, @NotNull Messageable recipient) {
        this.sendMessage(message, recipient, true);
    }

    @Override
    public void sendMessagePlain(@NotNull Message message, @NotNull Messageable recipient) {
        this.sendMessage(message, recipient, false);
    }

    @Override
    public void sendMessagePlain(@NotNull Message message, @NotNull Messageable recipient, @NotNull Map<String, String> placeholders) {
        this.sendMessage(message, recipient, placeholders, false);
    }

    @Override
    public void sendMessage(@NotNull Message message, @NotNull Messageable recipient, @NotNull Map<String, String> placeholders) {
        this.sendMessage(message, recipient, placeholders, true);
    }

    private void sendMessage(@NotNull Message message, @NotNull Messageable recipient, boolean usePrefix) {
        Object msgObject = this.enumMap.get((Object)message);
        if (msgObject instanceof String[]) {
            String[] msg;
            for (String str : msg = (String[])msgObject) {
                recipient.sendMessage(this.applyColor(str));
            }
            return;
        }
        if (msgObject instanceof String) {
            String str = (String)msgObject;
            String finalStr = usePrefix ? this.prefix + str : str;
            recipient.sendMessage(this.applyColor(finalStr));
            return;
        }
        this.warn(message);
    }

    private void sendMessage(@NotNull Message message, @NotNull Messageable recipient, @NotNull Map<String, String> placeholders, boolean usePrefix) {
        Object msg = this.enumMap.get((Object)message);
        if (msg instanceof String[]) {
            String[] array;
            for (String str : array = (String[])msg) {
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    str = str.replace(entry.getKey(), entry.getValue());
                }
                recipient.sendMessage(this.applyColor(str));
            }
            return;
        }
        if (msg instanceof String) {
            String str = (String)msg;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                str = str.replace(entry.getKey(), entry.getValue());
            }
            String finalStr = usePrefix ? this.prefix + str : str;
            recipient.sendMessage(this.applyColor(finalStr));
            return;
        }
        this.warn(message);
    }

    @Override
    public void batchSend(MessageContext ... contexts) {
        for (MessageContext context : contexts) {
            if (context.placeholders() != null) {
                this.sendMessage(context.message(), context.recipient(), context.placeholders(), context.usePrefix());
                continue;
            }
            this.sendMessage(context.message(), context.recipient(), context.usePrefix());
        }
    }

    private void warn(@NotNull Message message) {
        Bukkit.getLogger().warning("[Strings] Unknown object type or value not found for message " + String.valueOf((Object)message));
    }

    @Contract(value="_ -> new")
    @NotNull
    private String applyColor(@NotNull String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }
}

