/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.impl;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.StringsAPI;
import com.pedestriamc.strings.api.channel.ChannelLoader;
import com.pedestriamc.strings.api.message.Messenger;
import com.pedestriamc.strings.api.settings.Settings;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.chat.Mentioner;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class StringsImpl
implements StringsAPI {
    private final Strings strings;
    private final Mentioner mentioner;
    private final UserUtil userUtil;

    public StringsImpl(@NotNull Strings strings) {
        this.strings = strings;
        this.mentioner = strings.getMentioner();
        this.userUtil = strings.users();
    }

    @Override
    @NotNull
    public StringsUser getStringsUser(@NotNull UUID uuid) {
        return this.userUtil.getUser(uuid);
    }

    @Override
    @NotNull
    public StringsUser getStringsUser(@NotNull Player player) {
        return this.getStringsUser(player.getUniqueId());
    }

    @Override
    public void saveStringsUser(@NotNull StringsUser user) {
        if (user instanceof User) {
            User u = (User)user;
            this.userUtil.saveUser(u);
        }
    }

    @Override
    public boolean isPaper() {
        return this.strings.isPaper();
    }

    @Override
    public void mention(@NotNull Player subject, @NotNull Player sender) {
        this.mentioner.mention(subject, sender);
    }

    @Override
    public void mention(@NotNull StringsUser subject, @NotNull StringsUser sender) {
        this.mentioner.mention(User.playerOf(subject), User.playerOf(sender));
    }

    @Override
    public void sendMention(@NotNull Player player, @NotNull String message) {
        this.mentioner.sendMention(player, message);
    }

    @Override
    @NotNull
    public ChannelLoader getChannelLoader() {
        return this.strings.getChannelLoader();
    }

    @Override
    public short getVersion() {
        return 6;
    }

    @Override
    @NotNull
    public Messenger getMessenger() {
        return this.strings.getMessenger();
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.strings.getConfiguration();
    }
}

