/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.listener.chat;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.event.channel.ChannelChatEvent;
import com.pedestriamc.strings.api.text.format.ComponentConverter;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.chat.paper.ChannelChatRenderer;
import com.pedestriamc.strings.listener.chat.AbstractChatListener;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import io.papermc.paper.chat.ChatRenderer;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PaperChatListener
extends AbstractChatListener {
    private final Map<Channel, ChannelChatRenderer> renderers = new HashMap<Channel, ChannelChatRenderer>();
    private final Strings strings;
    private final UserUtil userUtil;

    public PaperChatListener(@NotNull Strings strings) {
        super(strings);
        this.strings = strings;
        this.userUtil = strings.users();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onEvent(@NotNull AsyncChatEvent event) {
        Player player = event.getPlayer();
        User user = this.userUtil.getUser(player);
        AbstractChatListener.Container container = this.processSymbol(ComponentConverter.toString(event.message()), user);
        Channel channel = container.channel();
        event.message(ComponentConverter.fromString(container.message()));
        channel = channel.resolve(user);
        if (!channel.callsEvents()) {
            channel.sendMessage(user, ComponentConverter.toString(event.message()));
            event.setCancelled(true);
            return;
        }
        Set<StringsUser> recipients = channel.getRecipients(user);
        event.viewers().clear();
        event.viewers().add(this.convertToAudience(recipients));
        event.viewers().add((Audience)this.strings.getServer().getConsoleSender());
        event.renderer((ChatRenderer)this.getRenderer(channel));
        this.callEvent(player, container.message(), this.convertToPlayers(recipients), channel);
    }

    @NotNull
    private ChannelChatRenderer getRenderer(@NotNull Channel channel) {
        return this.renderers.computeIfAbsent(channel, k -> new ChannelChatRenderer(this.strings, (Channel)k));
    }

    private void callEvent(Player sender, String message, Set<Player> players, Channel channel) {
        Bukkit.getScheduler().runTask((Plugin)this.strings, () -> this.strings.getServer().getPluginManager().callEvent((Event)new ChannelChatEvent(false, sender, message, players, channel, false)));
    }

    @NotNull
    private Set<Player> convertToPlayers(@NotNull Set<StringsUser> users) {
        return users.stream().map(User::playerOf).collect(Collectors.toSet());
    }

    @NotNull
    private Audience convertToAudience(@NotNull Set<StringsUser> set) {
        return Audience.audience(set.stream().map(p -> (Audience)User.playerOf(p)).toList());
    }
}

