/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.listener.mention;

import com.google.common.base.Preconditions;
import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.chat.Mentioner;
import com.pedestriamc.strings.listener.mention.AbstractMentionListener;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import net.luckperms.api.node.types.InheritanceNode;
import net.wiicart.commands.permission.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckPermsMentionListener
extends AbstractMentionListener {
    private final Strings strings;

    public LuckPermsMentionListener(@NotNull Strings strings) {
        super(strings);
        this.strings = strings;
        Preconditions.checkState((strings.getServer().getPluginManager().getPlugin("LuckPerms") != null ? 1 : 0) != 0, (Object)"LuckPerms plugin is not loaded");
    }

    @EventHandler
    void onEvent(@NotNull AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        String message = event.getMessage().toLowerCase(Locale.ROOT);
        if (!Mentioner.hasMentionPermission(sender)) {
            return;
        }
        LuckPerms luckPerms = this.getLuckPerms();
        if (luckPerms == null) {
            this.strings.warning("Failed to process message for mentions: LuckPerms unavailable.");
            return;
        }
        for (Player subj : Bukkit.getOnlinePlayers()) {
            if (!message.contains("@" + subj.getName().toLowerCase(Locale.ROOT))) continue;
            this.getMentioner().mention(subj, sender);
        }
        if (this.canMentionAll(sender) && message.contains("@everyone".toLowerCase(Locale.ROOT))) {
            for (Player subj : Bukkit.getOnlinePlayers()) {
                this.getMentioner().mention(subj, sender);
            }
        }
        if (Permissions.anyOfOrAdmin((Permissible)sender, "strings.*", "strings.mention.*", "strings.mention.group")) {
            for (Group group : luckPerms.getGroupManager().getLoadedGroups()) {
                if (!message.contains("@" + group.getName().toLowerCase(Locale.ROOT))) continue;
                this.mentionGroup(luckPerms, group, sender);
            }
        }
    }

    private void mentionGroup(@NotNull LuckPerms luckPerms, @NotNull Group group, @NotNull Player player) {
        NodeMatcher matcher = NodeMatcher.key((Node)((InheritanceNode)InheritanceNode.builder((String)group.getName()).build()));
        ((CompletableFuture)luckPerms.getUserManager().searchAll(matcher).exceptionally(throwable -> {
            this.strings.warning("Failed to message group '" + group.getName() + "'");
            this.strings.warning(throwable.getMessage());
            return null;
        })).thenAcceptAsync(result -> {
            if (result == null) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.strings, () -> {
                Mentioner mentioner = this.getMentioner();
                result.keySet().forEach(uuid -> {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p != null) {
                        mentioner.mention(p, player);
                    }
                });
            });
        });
    }

    @Nullable
    private LuckPerms getLuckPerms() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider == null) {
            return null;
        }
        return (LuckPerms)provider.getProvider();
    }
}

