/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.listener.player;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.deathmessages.DeathMessageManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerDeathListener
implements Listener {
    private final DeathMessageManager manager;
    private final boolean enableDeathMessages;
    private final boolean useCustomDeathMessages;

    public PlayerDeathListener(@NotNull Strings strings) {
        Configuration settings = strings.getConfiguration();
        this.enableDeathMessages = settings.getBoolean(Option.Bool.ENABLE_DEATH_MESSAGES);
        this.useCustomDeathMessages = settings.getBoolean(Option.Bool.USE_CUSTOM_DEATH_MESSAGES);
        this.manager = this.useCustomDeathMessages ? new DeathMessageManager(strings) : null;
    }

    @EventHandler
    void onEvent(@NotNull PlayerDeathEvent event) {
        if (!this.enableDeathMessages) {
            event.setDeathMessage(null);
        }
        if (!this.useCustomDeathMessages) {
            return;
        }
        EntityDamageEvent damageEvent = event.getEntity().getLastDamageCause();
        if (damageEvent == null) {
            return;
        }
        event.setDeathMessage(this.manager.getDeathMessage(event.getEntity(), damageEvent.getCause(), damageEvent));
    }
}

