/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.listener.player;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.misc.ServerMessages;
import com.pedestriamc.strings.user.util.UserUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerJoinListener
implements Listener {
    private final UserUtil userUtil;
    private final boolean modifyJoinMessage;
    private final ServerMessages serverMessages;
    private final boolean doMotd;
    private final boolean doJoinMessage;

    public PlayerJoinListener(@NotNull Strings strings) {
        this.userUtil = strings.users();
        this.serverMessages = strings.getServerMessages();
        Configuration configuration = strings.getConfiguration();
        this.modifyJoinMessage = configuration.getBoolean(Option.Bool.USE_CUSTOM_JOIN_LEAVE);
        this.doMotd = configuration.getBoolean(Option.Bool.ENABLE_MOTD);
        this.doJoinMessage = configuration.getBoolean(Option.Bool.ENABLE_JOIN_LEAVE_MESSAGE);
    }

    @EventHandler(priority=EventPriority.HIGH)
    void onEvent(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.userUtil.loadUserAsync(player.getUniqueId());
        if (!this.doJoinMessage) {
            event.setJoinMessage(null);
        } else if (this.modifyJoinMessage) {
            event.setJoinMessage(this.serverMessages.joinMessage(player));
        }
        if (this.doMotd) {
            this.serverMessages.sendMOTD(player);
        }
    }
}

