/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.listener.player;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.misc.ServerMessages;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerQuitListener
implements Listener {
    private final UserUtil userUtil;
    private final boolean modifyLeaveMessage;
    private final ServerMessages serverMessages;
    private final boolean doQuitMessage;

    public PlayerQuitListener(@NotNull Strings strings) {
        this.userUtil = strings.users();
        this.serverMessages = strings.getServerMessages();
        Configuration config = strings.getConfiguration();
        this.modifyLeaveMessage = config.getBoolean(Option.Bool.USE_CUSTOM_JOIN_LEAVE);
        this.doQuitMessage = config.getBoolean(Option.Bool.ENABLE_JOIN_LEAVE_MESSAGE);
    }

    @EventHandler
    void onEvent(@NotNull PlayerQuitEvent event) {
        User user = this.userUtil.getUser(event.getPlayer());
        if (!this.doQuitMessage) {
            event.setQuitMessage(null);
        } else if (this.modifyLeaveMessage) {
            event.setQuitMessage(this.serverMessages.leaveMessage(event.getPlayer()));
        }
        this.userUtil.removeUser(user.getUniqueId());
        user.logOff();
    }
}

