/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.log;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.log.LogType;
import java.io.File;
import java.io.FileWriter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class LogManager {
    private final Strings strings;

    public LogManager(@NotNull Strings strings) {
        this.strings = strings;
        this.loadTypes(strings.files().getLogsFileConfig());
    }

    void log(@NotNull LogType type, @NotNull String log) {
        if (type.isEnabled()) {
            this.write(type.getFile(), log);
        }
    }

    private synchronized void write(@NotNull File file, @NotNull String log) {
        this.strings.async(() -> {
            try (FileWriter fileWriter = new FileWriter(file, true);){
                fileWriter.write(log);
                fileWriter.write(System.lineSeparator());
            }
            catch (Exception e) {
                this.strings.warning("Failed to write log to file: " + file.getAbsolutePath());
                this.strings.warning("Error: " + e.getMessage());
            }
        });
    }

    private void loadTypes(@NotNull FileConfiguration config) {
        for (LogType type : LogType.TYPES) {
            type.setEnabled(config.getBoolean(type.getConfigKey()));
            if (type.isEnabled()) {
                this.register(type.createListener(this));
            }
            File file = new File(this.strings.getDataFolder(), type.getPath());
            this.prepareFile(file);
            type.setFile(file);
        }
    }

    private void prepareFile(@NotNull File file) {
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (Exception e) {
                this.strings.warning("Failed to create file \"" + file.getName() + "\"");
            }
        }
    }

    private void register(@NotNull Listener listener) {
        this.strings.getServer().getPluginManager().registerEvents(listener, (Plugin)this.strings);
    }
}

