/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.log;

import com.pedestriamc.strings.log.LogListener;
import com.pedestriamc.strings.log.LogManager;
import java.io.File;
import java.util.List;
import java.util.function.Function;
import org.bukkit.event.Listener;

final class LogType {
    private File file;
    private boolean enabled;
    private final String path;
    private final String configKey;
    private final Function<LogManager, Listener> function;
    static final LogType SIGN = new LogType("/logs/signs.txt", "sign-log", LogListener.SignListener::new);
    static final LogType DIRECT_MESSAGE = new LogType("/logs/direct-messages.txt", "dm-log", LogListener.DirectMessageListener::new);
    static final LogType CHAT = new LogType("/logs/chat.txt", "chat-log", LogListener.ChatListener::new);
    static final LogType COMMAND = new LogType("/logs/commands.txt", "command-log", LogListener.CommandListener::new);
    static final LogType FILTER = new LogType("/logs/filtered-messages.txt", "filter-log", LogListener.ChatFilterListener::new);
    static final List<LogType> TYPES = List.of(SIGN, DIRECT_MESSAGE, CHAT, COMMAND, FILTER);

    private LogType(String path, String configKey, Function<LogManager, Listener> function) {
        this.path = path;
        this.configKey = configKey;
        this.function = function;
    }

    Listener createListener(LogManager manager) {
        return this.function.apply(manager);
    }

    File getFile() {
        return this.file;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    String getPath() {
        return this.path;
    }

    String getConfigKey() {
        return this.configKey;
    }

    void setFile(File file) {
        this.file = file;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

