/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.manager;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.message.Message;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.commands.BroadcastCommand;
import com.pedestriamc.strings.commands.ChatColorCommand;
import com.pedestriamc.strings.commands.ClearChatCommand;
import com.pedestriamc.strings.commands.HelpOPCommand;
import com.pedestriamc.strings.commands.MentionCommand;
import com.pedestriamc.strings.commands.MessengerCommand;
import com.pedestriamc.strings.commands.SocialSpyCommand;
import com.pedestriamc.strings.commands.StringsCommand;
import com.pedestriamc.strings.commands.channel.ChannelCommand;
import com.pedestriamc.strings.commands.ignore.IgnoreCommand;
import com.pedestriamc.strings.commands.ignore.UnIgnoreCommand;
import com.pedestriamc.strings.commands.message.DirectMessageCommand;
import com.pedestriamc.strings.commands.message.ReplyCommand;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.listener.DirectMessageListener;
import com.pedestriamc.strings.listener.chat.PaperChatListener;
import com.pedestriamc.strings.listener.chat.SpigotChatListener;
import com.pedestriamc.strings.listener.mention.LuckPermsMentionListener;
import com.pedestriamc.strings.listener.mention.MentionListener;
import com.pedestriamc.strings.listener.player.PlayerDamageListener;
import com.pedestriamc.strings.listener.player.PlayerDeathListener;
import com.pedestriamc.strings.listener.player.PlayerJoinListener;
import com.pedestriamc.strings.listener.player.PlayerQuitListener;
import com.pedestriamc.strings.tabcompleters.ChannelTabCompleter;
import com.pedestriamc.strings.tabcompleters.ChatColorTabCompleter;
import com.pedestriamc.strings.tabcompleters.ClearChatTabCompleter;
import com.pedestriamc.strings.tabcompleters.IgnoreTabCompleter;
import com.pedestriamc.strings.tabcompleters.MentionCommandTabCompleter;
import com.pedestriamc.strings.tabcompleters.MessageTabCompleter;
import com.pedestriamc.strings.tabcompleters.SocialSpyTabCompleter;
import com.pedestriamc.strings.tabcompleters.StringsTabCompleter;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ClassRegistryManager {
    private final Strings strings;

    private ClassRegistryManager(Strings strings) {
        this.strings = strings;
    }

    public static void register(Strings strings) {
        ClassRegistryManager manager = new ClassRegistryManager(strings);
        manager.registerCommands();
        manager.registerListeners();
    }

    private void registerCommands() {
        Configuration config = this.strings.getConfiguration();
        this.registerCommand("strings", new StringsCommand(this.strings), new StringsTabCompleter());
        this.registerCommand("ignore", new IgnoreCommand(this.strings), new IgnoreTabCompleter());
        this.registerCommand("unignore", new UnIgnoreCommand(this.strings), new IgnoreTabCompleter());
        BroadcastCommand broadcastCommand = new BroadcastCommand(this.strings);
        this.registerCommand("broadcast", broadcastCommand, null);
        this.registerCommand("announce", broadcastCommand, null);
        ClearChatCommand clearChatCommand = new ClearChatCommand(this.strings);
        ClearChatTabCompleter clearChatTabCompleter = new ClearChatTabCompleter();
        this.registerCommand("clearchat", clearChatCommand, clearChatTabCompleter);
        this.registerCommand("chatclear", clearChatCommand, clearChatTabCompleter);
        this.registerCommand("socialspy", new SocialSpyCommand(this.strings), new SocialSpyTabCompleter());
        ChannelCommand channelCommand = new ChannelCommand(this.strings);
        ChannelTabCompleter channelTabCompleter = new ChannelTabCompleter(this.strings);
        this.registerCommand("channel", channelCommand, channelTabCompleter);
        this.registerCommand("c", channelCommand, channelTabCompleter);
        MentionCommand mentionCommand = new MentionCommand(this.strings);
        MentionCommandTabCompleter mentionCommandTabCompleter = new MentionCommandTabCompleter();
        this.registerCommand("mention", mentionCommand, mentionCommandTabCompleter);
        this.registerCommand("mentions", mentionCommand, mentionCommandTabCompleter);
        if (config.getBoolean(Option.Bool.ENABLE_DIRECT_MESSAGES)) {
            DirectMessageCommand directMessageCommand = new DirectMessageCommand(this.strings);
            MessageTabCompleter messageTabCompleter = new MessageTabCompleter();
            this.registerCommand("msg", directMessageCommand, messageTabCompleter);
            this.registerCommand("message", directMessageCommand, messageTabCompleter);
            ReplyCommand replyCommand = new ReplyCommand(this.strings);
            this.registerCommand("reply", replyCommand, null);
            this.registerCommand("r", replyCommand, null);
        }
        if (config.getBoolean(Option.Bool.ENABLE_CHATCOLOR_COMMAND)) {
            this.registerCommand("chatcolor", new ChatColorCommand(this.strings), new ChatColorTabCompleter());
        }
        if (config.getBoolean(Option.Bool.ENABLE_HELPOP)) {
            this.registerCommand("helpop", new HelpOPCommand(this.strings), null);
        } else {
            if (!config.getBoolean(Option.Bool.DISABLE_HELPOP_COMMAND)) {
                this.registerCommand("helpop", new MessengerCommand(this.strings, Message.HELPOP_DISABLED), null);
            }
            try {
                Channel helpOpChannel = this.strings.getChannelLoader().getChannel("helpop");
                if (helpOpChannel != null) {
                    this.strings.getChannelLoader().unregister(helpOpChannel);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void registerCommand(String commandName, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.strings.getCommand(commandName);
        if (command == null) {
            return;
        }
        command.setExecutor(executor);
        if (tabCompleter != null) {
            command.setTabCompleter(tabCompleter);
        }
    }

    private void registerListeners() {
        if (this.strings.isPaper()) {
            this.registerListener(new PaperChatListener(this.strings));
        } else {
            this.registerListener(new SpigotChatListener(this.strings));
        }
        this.registerListener(new PlayerJoinListener(this.strings));
        this.registerListener(new PlayerQuitListener(this.strings));
        this.registerListener(new DirectMessageListener(this.strings));
        this.registerListener(new PlayerDeathListener(this.strings));
        this.registerListener(new PlayerDamageListener(this.strings));
        if (this.strings.getConfiguration().getBoolean(Option.Bool.ENABLE_MENTIONS)) {
            if (this.strings.isUsingLuckPerms()) {
                this.registerListener(new LuckPermsMentionListener(this.strings));
            } else {
                this.registerListener(new MentionListener(this.strings));
            }
        }
    }

    private void registerListener(Listener listener) {
        this.strings.getServer().getPluginManager().registerEvents(listener, (Plugin)this.strings);
    }
}

