/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.manager;

import com.pedestriamc.strings.Strings;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class FileManager {
    private final Strings strings;
    private File broadcastsFile;
    private File messagesFile;
    private File channelsFile;
    private File usersFile;
    private FileConfiguration broadcastsFileConfig;
    private FileConfiguration messagesFileConfig;
    private FileConfiguration usersFileConfig;
    private FileConfiguration channelsFileConfig;
    private FileConfiguration logsFileConfig;
    private FileConfiguration moderationFileConfig;
    private FileConfiguration deathMessagesFileConfig;
    private static final Object userLock = new Object();
    private static final Object channelsLock = new Object();

    public FileManager(@NotNull Strings strings) {
        this.strings = strings;
        this.load();
    }

    private void load() {
        this.strings.saveDefaultConfig();
        this.updateConfigs();
        this.strings.reloadConfig();
        this.setupCustomConfigs();
    }

    private void setupCustomConfigs() {
        this.broadcastsFile = new File(this.strings.getDataFolder(), "broadcasts.yml");
        this.messagesFile = new File(this.strings.getDataFolder(), "messages.yml");
        this.usersFile = new File(this.strings.getDataFolder(), "users.yml");
        this.channelsFile = new File(this.strings.getDataFolder(), "channels.yml");
        File deathMessagesFile = new File(this.strings.getDataFolder(), "death-messages.yml");
        File logsFile = new File(this.strings.getDataFolder(), "logs.yml");
        File moderationFile = new File(this.strings.getDataFolder(), "moderation.yml");
        this.createIfDoesNotExist(this.broadcastsFile, "broadcasts.yml");
        this.createIfDoesNotExist(this.messagesFile, "messages.yml");
        this.createIfDoesNotExist(this.usersFile, "users.yml");
        this.createIfDoesNotExist(this.channelsFile, "channels.yml");
        this.createIfDoesNotExist(deathMessagesFile, "death-messages.yml");
        this.createIfDoesNotExist(logsFile, "logs.yml");
        this.createIfDoesNotExist(moderationFile, "moderation.yml");
        this.broadcastsFileConfig = YamlConfiguration.loadConfiguration((File)this.broadcastsFile);
        this.messagesFileConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.usersFileConfig = YamlConfiguration.loadConfiguration((File)this.usersFile);
        this.channelsFileConfig = YamlConfiguration.loadConfiguration((File)this.channelsFile);
        this.deathMessagesFileConfig = YamlConfiguration.loadConfiguration((File)deathMessagesFile);
        this.logsFileConfig = YamlConfiguration.loadConfiguration((File)logsFile);
        this.moderationFileConfig = YamlConfiguration.loadConfiguration((File)moderationFile);
    }

    private void createIfDoesNotExist(@NotNull File file, @NotNull String resourcePath) {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.strings.saveResource(resourcePath, false);
        }
    }

    private void updateConfigs() {
        this.updateIfPresent("config.yml");
        this.updateIfPresent("messages.yml");
        this.updateIfPresent("moderation.yml");
        this.updateIfPresent("death-messages.yml");
    }

    private void updateIfPresent(String resourceName) {
        File file = new File(this.strings.getDataFolder(), resourceName);
        if (file.exists()) {
            try {
                ConfigUpdater.update((Plugin)this.strings, resourceName, file, new String[0]);
            }
            catch (IOException e) {
                this.strings.warning("Failed to update file " + resourceName + ". " + e.getMessage());
            }
        }
    }

    @NotNull
    public FileConfiguration getConfig() {
        return this.strings.getConfig();
    }

    @NotNull
    public FileConfiguration getUsersFileConfig() {
        return this.usersFileConfig;
    }

    @NotNull
    public FileConfiguration getBroadcastsFileConfig() {
        return this.broadcastsFileConfig;
    }

    @NotNull
    public FileConfiguration getMessagesFileConfig() {
        return this.messagesFileConfig;
    }

    @NotNull
    public FileConfiguration getChannelsFileConfig() {
        return this.channelsFileConfig;
    }

    @NotNull
    public FileConfiguration getDeathMessagesFileConfig() {
        return this.deathMessagesFileConfig;
    }

    @NotNull
    public FileConfiguration getLogsFileConfig() {
        return this.logsFileConfig;
    }

    @NotNull
    public FileConfiguration getModerationFileConfig() {
        return this.moderationFileConfig;
    }

    public void saveUsersFile() {
        this.strings.async(() -> {
            Object object = userLock;
            synchronized (object) {
                try {
                    this.usersFileConfig.save(this.usersFile);
                }
                catch (Exception e) {
                    this.strings.warning("An error occurred while saving the users file: " + e.getMessage());
                }
            }
        });
    }

    public synchronized void saveChannelsFile() {
        this.strings.async(() -> {
            Object object = channelsLock;
            synchronized (object) {
                try {
                    this.channelsFileConfig.save(this.channelsFile);
                }
                catch (IOException e) {
                    this.strings.warning("An error occurred while saving the channels file: " + e.getMessage());
                }
            }
        });
    }

    public void saveMessagesFile() {
        try {
            this.messagesFileConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveBroadcastsFile() {
        try {
            this.broadcastsFileConfig.save(this.broadcastsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

