/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.misc;

import com.pedestriamc.strings.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public final class AutoBroadcasts {
    private final Strings strings;
    private final FileConfiguration config;
    private final BukkitScheduler scheduler = Bukkit.getScheduler();
    private final ArrayList<String[]> broadcastList = new ArrayList();
    private int pos;
    private long interval;
    private final String order;

    public AutoBroadcasts(@NotNull Strings strings) {
        this.strings = strings;
        this.config = strings.files().getBroadcastsFileConfig();
        this.order = this.config.getString("sequence");
        if (this.config.getBoolean("enabled", false)) {
            this.interval = AutoBroadcasts.calculateTicks(this.config.getString("delay"));
            if (this.interval == -1L) {
                Bukkit.getLogger().info("[Strings] Invalid delay for auto broadcasts. Defaulting to 3 minutes. ");
                this.interval = 3600L;
            }
            this.loadBroadcastList();
            this.schedule();
        }
    }

    private void schedule() {
        this.scheduler.runTaskTimer((Plugin)this.strings, this::broadcastMessage, 20L, this.interval);
    }

    private void broadcastMessage() {
        if (this.pos == this.broadcastList.size()) {
            this.pos = 0;
            if (this.order.equalsIgnoreCase("random")) {
                Collections.shuffle(this.broadcastList);
            }
        }
        for (int i = 0; i < this.broadcastList.get(this.pos).length; ++i) {
            Bukkit.broadcastMessage((String)this.broadcastList.get(this.pos)[i]);
        }
        ++this.pos;
    }

    private void loadBroadcastList() {
        ConfigurationSection section = this.config.getConfigurationSection("broadcasts");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ArrayList<String> messages = new ArrayList<String>();
                List messageList = section.getList(key);
                if (messageList != null) {
                    for (Object obj : messageList) {
                        if (!(obj instanceof String)) continue;
                        String string = (String)obj;
                        messages.add(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
                    }
                }
                this.broadcastList.add(messages.toArray(new String[0]));
            }
        }
        if (this.broadcastList.isEmpty()) {
            Bukkit.getLogger().warning("[Strings] No broadcasts found in broadcasts.yml");
        }
    }

    private static long calculateTicks(String time) {
        String regex = "^[0-9]+[sm]$";
        if (time == null || !time.matches(regex)) {
            return -1L;
        }
        char units = time.charAt(time.length() - 1);
        time = time.substring(0, time.length() - 1);
        int delayNum = Integer.parseInt(time);
        if (units == 'm') {
            delayNum *= 60;
        }
        return (long)delayNum * 20L;
    }
}

