/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.misc;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.settings.Option;
import com.pedestriamc.strings.configuration.Configuration;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ServerMessages {
    private final UserUtil userUtil;
    private final String joinMessageTemplate;
    private final String leaveMessageTemplate;
    private final List<String> motd;
    private final boolean usePAPI;

    public ServerMessages(@NotNull Strings strings) {
        this.userUtil = strings.users();
        this.usePAPI = strings.isUsingPlaceholderAPI();
        Configuration config = strings.getConfiguration();
        this.joinMessageTemplate = config.getString(Option.Text.JOIN_MESSAGE);
        this.leaveMessageTemplate = config.getString(Option.Text.LEAVE_MESSAGE);
        this.motd = config.getStringList(Option.StringList.MOTD);
    }

    public String joinMessage(Player player) {
        String message = this.joinMessageTemplate;
        User user = this.userUtil.getUser(player);
        if (this.usePAPI) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        message = this.applyPlaceholders(message, user);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String leaveMessage(Player player) {
        String message = this.leaveMessageTemplate;
        User user = this.userUtil.getUser(player);
        if (this.usePAPI) {
            message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
        }
        message = this.applyPlaceholders(message, user);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void sendMOTD(Player player) {
        ArrayList<String> playerMOTD = new ArrayList<String>(this.motd);
        User user = this.userUtil.getUser(player);
        for (String message : playerMOTD) {
            message = this.applyPlaceholders(message, user);
            if (this.usePAPI) {
                message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
            }
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            player.sendMessage(message);
        }
    }

    @NotNull
    private String applyPlaceholders(@NotNull String message, User user) {
        Player player = user.player();
        return message.replace("{displayname}", player.getDisplayName()).replace("{username}", player.getName()).replace("{prefix}", user.getPrefix()).replace("{suffix}", user.getSuffix());
    }
}

