/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.tabcompleters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

abstract class AbstractTabCompleter
implements TabCompleter {
    @NotNull
    static final List<String> EMPTY = List.of();

    AbstractTabCompleter() {
    }

    @NotNull
    final List<String> getPlayerNames() {
        Collection players = Bukkit.getOnlinePlayers();
        ArrayList<String> list = new ArrayList<String>(players.size());
        for (Player p : players) {
            list.add(p.getName());
        }
        return list;
    }

    @NotNull
    final List<String> filter(@NotNull List<String> list, @NotNull String input) {
        return list.stream().filter(arg -> arg.toLowerCase().startsWith(input.toLowerCase())).toList();
    }

    @SafeVarargs
    @Contract(value="_ -> new")
    @NotNull
    final List<String> combine(Collection<String> ... collections) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Collection<String> collection : collections) {
            set.addAll(collection);
        }
        return new ArrayList<String>(set);
    }

    @SafeVarargs
    @Contract(value="_, _ -> new")
    @NotNull
    final List<String> combine(@NotNull String string, Collection<String> ... collections) {
        List<String> list = this.combine(collections);
        if (!list.contains(string)) {
            list.add(string);
        }
        return list;
    }
}

