/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.tabcompleters;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Type;
import com.pedestriamc.strings.chat.ChannelManager;
import com.pedestriamc.strings.tabcompleters.AbstractTabCompleter;
import java.util.List;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class ChannelTabCompleter
extends AbstractTabCompleter {
    private static final Set<String> CASES = Set.of("join", "leave", "monitor", "unmonitor", "broadcast", "announce", "mute", "unmute", "list");
    private static final String HELP = "help";
    @NotNull
    private final ChannelManager channelLoader;

    public ChannelTabCompleter(@NotNull Strings strings) {
        this.channelLoader = strings.getChannelLoader();
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        return switch (args.length) {
            case 0 -> this.combine(HELP, this.getAllowedChannels(sender), CASES);
            case 1 -> this.filter(this.combine(HELP, this.getAllowedChannels(sender), CASES), args[0]);
            case 2 -> {
                if (CASES.contains(args[0].toLowerCase())) {
                    yield this.filter(this.getAllowedChannels(sender), args[1]);
                }
                yield this.filter(this.getPlayerNames(), args[1]);
            }
            case 3 -> this.filter(this.getPlayerNames(), args[2]);
            default -> EMPTY;
        };
    }

    private List<String> getAllowedChannels(CommandSender sender) {
        return this.channelLoader.getChannels().stream().filter(channel -> channel.getType() != Type.PROTECTED).filter(channel -> channel.allows((Permissible)sender)).map(Channel::getName).toList();
    }
}

