/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.user;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.api.collections.BoundedLinkedBuffer;
import com.pedestriamc.strings.api.event.channel.UserChannelEvent;
import com.pedestriamc.strings.api.text.format.StringsComponent;
import com.pedestriamc.strings.api.user.StringsUser;
import com.pedestriamc.strings.chat.ChannelManager;
import com.pedestriamc.strings.user.UserBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class User
implements StringsUser {
    private final boolean retain;
    private final Strings strings;
    private final ChannelManager channelLoader;
    private final UUID uuid;
    private final Player player;
    private final Audience audience;
    private final String name;
    private final Set<Channel> channels;
    private final Set<Monitorable> monitored;
    private final Set<UUID> ignored;
    private final Set<Channel> mutes;
    private Channel activeChannel;
    private StringsComponent chatColorComponent;
    @Nullable
    private String prefix;
    @Nullable
    private String suffix;
    @Nullable
    private String displayName;
    private boolean mentionsEnabled;
    private boolean msgEnabled;
    BoundedLinkedBuffer<EntityDamageEvent> previousDamage = new BoundedLinkedBuffer(2);
    private volatile boolean dirty = true;
    private Map<String, Object> data;

    public static User of(@NotNull StringsUser user) {
        if (user instanceof User) {
            User u = (User)user;
            return u;
        }
        throw new RuntimeException("Provided User does not implement StringsBukkit User.");
    }

    public static Player playerOf(@NotNull StringsUser user) {
        if (user instanceof User) {
            User u = (User)user;
            return u.player();
        }
        UUID uniqueId = user.getUniqueId();
        return Bukkit.getPlayer((UUID)uniqueId);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static UserBuilder builder(Strings strings, UUID uuid, boolean retained) {
        return new UserBuilder(strings, uuid, retained);
    }

    User(@NotNull UserBuilder builder) {
        this.strings = builder.strings;
        this.channelLoader = this.strings.getChannelLoader();
        this.uuid = builder.uuid;
        this.retain = builder.retained;
        this.player = Objects.requireNonNull(this.strings.getServer().getPlayer(this.uuid));
        this.audience = this.loadAudience(this.uuid);
        this.name = this.player.getName();
        this.chatColorComponent = StringsComponent.fromString(this.color(Objects.requireNonNullElse(builder.chatColor, "")));
        this.prefix = Objects.requireNonNullElse(builder.prefix, "");
        this.suffix = Objects.requireNonNullElse(builder.suffix, "");
        this.displayName = Objects.requireNonNullElse(builder.displayName, "");
        this.activeChannel = builder.activeChannel != null ? builder.activeChannel : this.channelLoader.getDefaultChannel();
        this.mentionsEnabled = builder.mentionsEnabled;
        this.msgEnabled = builder.msgEnabled;
        this.channels = Objects.requireNonNullElseGet(builder.channels, HashSet::new);
        this.monitored = Objects.requireNonNullElseGet(builder.monitoredChannels, HashSet::new);
        this.ignored = Objects.requireNonNullElseGet(builder.ignored, HashSet::new);
        this.mutes = Objects.requireNonNullElseGet(builder.mutes, HashSet::new);
        if (this.channels.isEmpty()) {
            this.joinChannel(this.channelLoader.getDefaultChannel());
        }
        this.joinChannels();
    }

    public void logOff() {
        for (Channel channel : this.channels) {
            channel.removeMember(this);
        }
        for (Monitorable monitorable : this.monitored) {
            monitorable.removeMonitor(this);
        }
    }

    private void joinChannels() {
        for (Channel channel : this.channels) {
            channel.addMember(this);
        }
        for (Monitorable monitorable : this.monitored) {
            monitorable.addMonitor(this);
        }
    }

    @NotNull
    private Audience loadAudience(@NotNull UUID uuid) {
        return this.strings.adventure().player(uuid);
    }

    @Nullable
    public EntityDamageEvent getSecondToLastDamage() {
        if (this.previousDamage.size() < 2) {
            return null;
        }
        BoundedLinkedBuffer.Node<EntityDamageEvent> tail = this.previousDamage.getTail();
        if (tail != null) {
            return tail.get();
        }
        return null;
    }

    public void pushDamageEvent(@NotNull EntityDamageEvent event) {
        this.previousDamage.add(event);
    }

    @Override
    public void sendMessage(@NotNull String message) {
        this.player().sendMessage(message);
    }

    @Override
    public void sendMessage(@NotNull Component message) {
        Player player = this.player;
        if (player instanceof Audience) {
            Audience a = (Audience)player;
            a.sendMessage(message);
        } else {
            this.audience.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, Object> getData() {
        User user = this;
        synchronized (user) {
            if (this.dirty || this.data == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("chat-color", this.getChatColorComponent().toString());
                map.put("prefix", Objects.requireNonNullElse(this.prefix, ""));
                map.put("suffix", Objects.requireNonNullElse(this.suffix, ""));
                map.put("display-name", Objects.requireNonNullElse(this.displayName, ""));
                map.put("active-channel", this.activeChannel.getName());
                map.put("channels", this.getNames(this.channels));
                map.put("monitored-channels", this.getNames(this.monitored));
                map.put("muted-channels", this.getNames(this.mutes));
                map.put("ignored-players", new ArrayList<UUID>(this.ignored));
                map.put("mentions-enabled", this.mentionsEnabled);
                map.put("msg-enabled", this.msgEnabled);
                this.data = map;
            }
            return this.data;
        }
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public World getWorld() {
        return this.player.getWorld();
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public StringsComponent getChatColorComponent() {
        return this.chatColorComponent;
    }

    @Override
    public void setChatColorComponent(StringsComponent chatColor) {
        Objects.requireNonNull(chatColor);
        if (!this.chatColorComponent.equals(chatColor)) {
            this.chatColorComponent = chatColor;
            this.dirty = true;
        }
    }

    @Override
    @ApiStatus.Obsolete
    public void setChatColor(String chatColor) {
        this.setChatColorComponent(StringsComponent.fromString(chatColor));
        this.dirty = true;
    }

    @Override
    @NotNull
    @ApiStatus.Obsolete
    public String getChatColor() {
        return this.color(this.getChatColorComponent().toString());
    }

    @ApiStatus.Obsolete
    public String getChatColor(@NotNull Channel channel) {
        String chatColor = this.getChatColor();
        if (chatColor.isEmpty()) {
            return channel.getDefaultColor();
        }
        return chatColor;
    }

    @Override
    public void setDisplayName(@NotNull String displayName) {
        this.displayName = displayName;
        this.player.setDisplayName(displayName);
        this.dirty = true;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return this.player.getDisplayName();
        }
        return this.color(this.displayName);
    }

    @Override
    public void setPrefix(@NotNull String prefix) {
        this.prefix = prefix;
        if (this.strings.isUsingVault()) {
            this.strings.getVaultChat().setPlayerPrefix(this.player, prefix);
        }
        this.dirty = true;
    }

    @Override
    @NotNull
    public String getPrefix() {
        if (this.strings.isUsingVault()) {
            return this.color(this.strings.getVaultChat().getPlayerPrefix(this.player));
        }
        if (this.prefix == null || this.prefix.isEmpty()) {
            return "";
        }
        return this.color(this.prefix);
    }

    @Override
    public void setSuffix(@NotNull String suffix) {
        this.suffix = suffix;
        if (this.strings.isUsingVault()) {
            this.strings.getVaultChat().setPlayerSuffix(this.player, suffix);
        }
        this.dirty = true;
    }

    @Override
    @NotNull
    public String getSuffix() {
        if (this.strings.isUsingVault()) {
            return this.color(this.strings.getVaultChat().getPlayerSuffix(this.player));
        }
        if (this.suffix == null || this.suffix.isEmpty()) {
            return "";
        }
        return this.color(this.suffix);
    }

    @Override
    public void setMentionsEnabled(boolean mentionsEnabled) {
        if (this.mentionsEnabled != mentionsEnabled) {
            this.mentionsEnabled = mentionsEnabled;
            this.dirty = true;
        }
    }

    @Override
    public boolean isMentionsEnabled() {
        return this.mentionsEnabled;
    }

    @Override
    public boolean isIgnoring(@NotNull StringsUser other) {
        return this.getIgnoredPlayers().contains(other.getUniqueId());
    }

    @Override
    public void ignore(@NotNull StringsUser user) {
        Objects.requireNonNull(user);
        if (user.equals(this)) {
            return;
        }
        this.ignored.add(user.getUniqueId());
        this.dirty = true;
    }

    @Override
    public void stopIgnoring(@NotNull StringsUser user) {
        Objects.requireNonNull(user);
        this.ignored.remove(user.getUniqueId());
        this.dirty = true;
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public Set<UUID> getIgnoredPlayers() {
        return new HashSet<UUID>(this.ignored);
    }

    @Override
    public boolean memberOf(Channel channel) {
        return this.channels.contains(channel);
    }

    @Override
    public void setActiveChannel(@NotNull Channel channel) {
        Objects.requireNonNull(channel);
        if (!this.activeChannel.equals(channel)) {
            this.activeChannel = channel;
            this.dirty = true;
            if (!this.channels.contains(channel)) {
                this.joinChannel(channel);
            }
            this.callEvent(new UserChannelEvent(channel, this, UserChannelEvent.Type.UPDATE_ACTIVE));
        }
    }

    @Override
    @NotNull
    public Channel getActiveChannel() {
        return this.activeChannel;
    }

    @Override
    public void joinChannel(@NotNull Channel channel) {
        Objects.requireNonNull(channel);
        if (!this.channels.contains(channel)) {
            channel.addMember(this);
            this.channels.add(channel);
            this.callEvent(new UserChannelEvent(channel, this, UserChannelEvent.Type.JOIN));
            this.dirty = true;
        }
    }

    @Override
    public void leaveChannel(@NotNull Channel channel) {
        Objects.requireNonNull(channel);
        if (channel.equals(this.channelLoader.getDefaultChannel())) {
            this.strings.warning("[Strings] Player " + this.player.getName() + " just tried to leave channel global. This is not permitted.");
            return;
        }
        if (this.channels.contains(channel)) {
            this.channels.remove(channel);
            channel.removeMember(this);
            if (this.activeChannel.equals(channel)) {
                this.activeChannel = this.channelLoader.getDefaultChannel();
            }
            this.callEvent(new UserChannelEvent(channel, this, UserChannelEvent.Type.LEAVE));
            this.dirty = true;
        }
    }

    @Override
    @NotNull
    public Set<Channel> getChannels() {
        return new HashSet<Channel>(this.channels);
    }

    private List<String> getNames(@NotNull Collection<? extends Channel> collection) {
        return collection.stream().filter(Objects::nonNull).map(Channel::getName).toList();
    }

    @Override
    public void monitor(@NotNull Monitorable monitorable) {
        Objects.requireNonNull(monitorable);
        if (!this.monitored.contains(monitorable)) {
            this.monitored.add(monitorable);
            monitorable.addMonitor(this);
            this.callEvent(new UserChannelEvent(monitorable, this, UserChannelEvent.Type.MONITOR));
            this.dirty = true;
        }
    }

    @Override
    public void unmonitor(@NotNull Monitorable monitorable) {
        Objects.requireNonNull(monitorable);
        if (this.monitored.contains(monitorable)) {
            this.monitored.remove(monitorable);
            monitorable.removeMonitor(this);
            this.callEvent(new UserChannelEvent(monitorable, this, UserChannelEvent.Type.UNMONITOR));
            this.dirty = true;
        }
    }

    @Override
    @Contract(value=" -> new", pure=true)
    @NotNull
    public Set<Channel> getMonitoredChannels() {
        return new HashSet<Channel>(this.monitored);
    }

    @Override
    public boolean isMonitoring(@NotNull Monitorable monitorable) {
        return this.monitored.contains(monitorable);
    }

    @Override
    public void muteChannel(@NotNull Channel channel) {
        this.leaveChannel(channel);
        if (channel instanceof Monitorable) {
            Monitorable monitorable = (Monitorable)channel;
            this.unmonitor(monitorable);
        }
        this.mutes.add(channel);
        this.dirty = true;
    }

    @Override
    public void unmuteChannel(@NotNull Channel channel) {
        this.mutes.remove(channel);
        this.dirty = true;
    }

    @Override
    @NotNull
    public Set<Channel> getMutedChannels() {
        return new HashSet<Channel>(this.mutes);
    }

    @Override
    public boolean hasChannelMuted(@NotNull Channel channel) {
        return this.mutes.contains(channel);
    }

    @Override
    public boolean hasDirectMessagesEnabled() {
        return this.msgEnabled;
    }

    @Override
    public void setDirectMessagesEnabled(boolean msgEnabled) {
        this.msgEnabled = msgEnabled;
        this.dirty = true;
    }

    public boolean isRetained() {
        return this.retain;
    }

    @Contract(value="_ -> new")
    @NotNull
    private String color(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    private void callEvent(@NotNull Event event) {
        this.strings.getServer().getScheduler().runTask((Plugin)this.strings, () -> this.strings.getServer().getPluginManager().callEvent(event));
    }

    public String toString() {
        return this.getData().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.uuid.equals(user.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

