/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.user;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.user.User;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class UserBuilder {
    @NotNull
    final Strings strings;
    @NotNull
    final UUID uuid;
    final boolean retained;
    Channel activeChannel;
    Set<Channel> channels;
    Set<Channel> mutes;
    Set<Monitorable> monitoredChannels;
    Set<UUID> ignored;
    String chatColor;
    String prefix;
    String suffix;
    String displayName;
    boolean mentionsEnabled = true;
    boolean msgEnabled = true;

    UserBuilder(@NotNull Strings strings, @NotNull UUID uuid, boolean retained) {
        this.strings = strings;
        this.uuid = uuid;
        this.retained = retained;
    }

    public UserBuilder channels(Set<Channel> channels) {
        this.channels = channels;
        return this;
    }

    public UserBuilder monitoredChannels(Set<Monitorable> monitoredChannels) {
        this.monitoredChannels = monitoredChannels;
        return this;
    }

    public UserBuilder ignoredPlayers(Set<UUID> ignored) {
        this.ignored = ignored;
        return this;
    }

    public UserBuilder mutedChannels(Set<Channel> mutes) {
        this.mutes = mutes;
        return this;
    }

    public UserBuilder chatColor(String chatColor) {
        this.chatColor = chatColor;
        return this;
    }

    public UserBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public UserBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public UserBuilder displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public UserBuilder activeChannel(Channel activeChannel) {
        this.activeChannel = activeChannel;
        return this;
    }

    public UserBuilder mentionsEnabled(boolean mentionsEnabled) {
        this.mentionsEnabled = mentionsEnabled;
        return this;
    }

    public UserBuilder msgEnabled(boolean msgEnabled) {
        this.msgEnabled = msgEnabled;
        return this;
    }

    @Contract(value=" -> new")
    @NotNull
    public User build() {
        return new User(this);
    }
}

