/*
 * Decompiled with CFR 0.152.
 */
package com.pedestriamc.strings.user.util;

import com.pedestriamc.strings.Strings;
import com.pedestriamc.strings.api.channel.Channel;
import com.pedestriamc.strings.api.channel.Monitorable;
import com.pedestriamc.strings.chat.ChannelManager;
import com.pedestriamc.strings.user.User;
import com.pedestriamc.strings.user.util.UserUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class YamlUserUtil
implements UserUtil {
    private final Strings strings;
    private final FileConfiguration config;
    private final Map<UUID, User> map;

    public YamlUserUtil(@NotNull Strings strings) {
        this.strings = strings;
        this.config = strings.files().getUsersFileConfig();
        this.map = new ConcurrentHashMap<UUID, User>();
    }

    @Override
    public void saveUser(@NotNull User user) {
        UUID uuid = user.getUniqueId();
        Map<String, Object> infoMap = user.getData();
        this.strings.async(() -> {
            FileConfiguration fileConfiguration = this.config;
            synchronized (fileConfiguration) {
                for (Map.Entry element : infoMap.entrySet()) {
                    Object value = element.getValue();
                    if (element.getKey() == null || value == null) continue;
                    this.config.set("players." + String.valueOf(uuid) + "." + (String)element.getKey(), value);
                }
                this.strings.files().saveUsersFile();
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<User> loadUserAsync(@NotNull UUID uuid) {
        CompletableFuture<User> future = new CompletableFuture<User>();
        this.strings.async(() -> {
            try {
                User user = this.loadUser(uuid);
                future.complete(user);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public User loadUser(UUID uuid) {
        FileConfiguration fileConfiguration = this.config;
        synchronized (fileConfiguration) {
            ConfigurationSection section = this.config.getConfigurationSection("players." + String.valueOf(uuid));
            if (section == null) {
                User user = User.builder(this.strings, uuid, true).build();
                this.addUser(user);
                return user;
            }
            User user = User.builder(this.strings, uuid, true).suffix(section.getString(".suffix")).prefix(section.getString(".prefix")).displayName(section.getString(".display-name")).chatColor(section.getString(".chat-color")).mentionsEnabled(section.getBoolean(".mentions-enabled")).msgEnabled(section.getBoolean(".msg-enabled")).activeChannel(this.strings.getChannelLoader().getChannel(this.getStringNonNull(section, ".active-channel"))).channels(this.getChannels(section.getList(".channels"))).mutedChannels(this.getChannels(section.getList(".muted-channels"))).monitoredChannels(this.getMonitorables(section.getList(".monitored-channels"))).ignoredPlayers(this.getUniqueIds(section.getList(".ignored-players"))).build();
            this.addUser(user);
            return user;
        }
    }

    private Set<Monitorable> getMonitorables(List<?> list) {
        return this.getChannels(list).stream().filter(Objects::nonNull).filter(Monitorable.class::isInstance).map(Monitorable.class::cast).collect(Collectors.toSet());
    }

    @Contract(value="null -> new")
    @NotNull
    private Set<Channel> getChannels(List<?> list) {
        if (list == null) {
            return new HashSet<Channel>();
        }
        ChannelManager loader = this.strings.getChannelLoader();
        HashSet<Channel> channels = new HashSet<Channel>();
        for (Object item : list) {
            String name;
            Channel channel;
            if (!(item instanceof String) || (channel = loader.getChannel(name = (String)item)) == null) continue;
            channels.add(channel);
        }
        return channels;
    }

    @Contract(value="null -> new")
    @NotNull
    private Set<UUID> getUniqueIds(List<?> list) {
        if (list == null) {
            return new HashSet<UUID>();
        }
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (Object item : list) {
            if (!(item instanceof String)) continue;
            String string = (String)item;
            try {
                UUID uuid = UUID.fromString(string);
                uuids.add(uuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return uuids;
    }

    private String getStringNonNull(@NotNull ConfigurationSection section, @NotNull String key) {
        return Objects.requireNonNullElse(section.getString(key), "");
    }

    @Override
    @NotNull
    public User getUser(UUID uuid) {
        User user = this.map.get(uuid);
        if (user == null) {
            return User.builder(this.strings, uuid, false).build();
        }
        return user;
    }

    @Override
    @NotNull
    public User getUser(@NotNull Player player) {
        return this.getUser(player.getUniqueId());
    }

    @Override
    @Nullable
    public User getUser(@NotNull String name) {
        Player player = this.strings.getServer().getPlayer(name);
        if (player != null) {
            return this.getUser(player.getUniqueId());
        }
        return null;
    }

    @Override
    public void addUser(User user) {
        this.map.put(user.getUniqueId(), user);
    }

    @Override
    public void removeUser(UUID uuid) {
        this.map.remove(uuid);
    }

    @Override
    @Contract(value=" -> new")
    @NotNull
    public Set<User> getUsers() {
        return new HashSet<User>(this.map.values());
    }
}

