/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.command.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.wiicart.commands.command.CartCommandExecutor;
import net.wiicart.commands.command.CommandData;
import net.wiicart.commands.command.argument.ArgumentSequence;
import net.wiicart.commands.command.tree.CommandExecutionException;
import net.wiicart.commands.command.tree.TreeBuilder;
import net.wiicart.commands.tabcomplete.TabCompleteUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class CommandTree
implements CommandExecutor,
TabCompleter {
    private final Node root;

    @NotNull
    public static TreeBuilder builder() {
        return new TreeBuilder();
    }

    protected CommandTree(@NotNull Node root) {
        this.root = root;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        this.root.onCommand(sender, command, label, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.root.onTabComplete(sender, command, alias, args);
    }

    public static interface Node
    extends CommandExecutor,
    TabCompleter,
    CartCommandExecutor {
        default public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            try {
                if (args.length > 0) {
                    for (Node node : this.children()) {
                        if (!node.matches(args[0])) continue;
                        return node.onCommand(sender, command, label, Arrays.copyOfRange(args, 1, args.length));
                    }
                }
                this.onCommand(new CommandData(args, sender, label, command));
            }
            catch (Exception e) {
                if (e instanceof CommandExecutionException) {
                    CommandExecutionException ex = (CommandExecutionException)e;
                    throw ex.addNode(this.name());
                }
                throw new CommandExecutionException(e).addNode(this.name());
            }
            return true;
        }

        default public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.name());
            if (args.length == 0) {
                return list;
            }
            if (args.length == 1) {
                return TabCompleteUtil.filter(list, args[0]);
            }
            for (Node node : this.children()) {
                if (!node.matches(args[1])) continue;
                return node.onTabComplete(sender, command, alias, Arrays.copyOfRange(args, 1, args.length));
            }
            return list;
        }

        default public boolean matches(@NotNull String arg) {
            for (String str : this.aliases()) {
                if (!str.equalsIgnoreCase(arg)) continue;
                return true;
            }
            return this.name().equalsIgnoreCase(arg);
        }

        @NotNull
        public String name();

        @NotNull
        public Set<Node> children();

        @ApiStatus.Experimental
        @NotNull
        public Set<ArgumentSequence> arguments();

        @NotNull
        public Set<String> aliases();

        public boolean isLeaf();
    }
}

