/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.permission;

import java.util.Objects;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class Permissions {
    private final PluginManager pluginManager;

    public Permissions(@NotNull JavaPlugin plugin) {
        Objects.requireNonNull(plugin);
        this.pluginManager = plugin.getServer().getPluginManager();
    }

    public void addPermission(@NotNull Permission permission) {
        this.pluginManager.addPermission(permission);
    }

    public void addPermissions(Permission ... permissions) {
        for (Permission permission : permissions) {
            this.addPermission(permission);
        }
    }

    public void addPermission(@NotNull String permission) {
        this.addPermission(new Permission(permission));
    }

    public void addPermissions(String ... permissions) {
        for (String permission : permissions) {
            this.addPermission(permission);
        }
    }

    public void removePermission(@NotNull Permission permission) {
        this.pluginManager.removePermission(permission);
    }

    public void removePermissions(Permission ... permissions) {
        for (Permission permission : permissions) {
            this.removePermission(permission);
        }
    }

    public void removePermission(@NotNull String permission) {
        this.pluginManager.removePermission(permission);
    }

    public void removePermissions(String ... permissions) {
        for (String permission : permissions) {
            this.removePermission(permission);
        }
    }

    public static boolean anyOf(@NotNull Permissible permissible, String ... permissions) {
        for (String permission : permissions) {
            if (!permissible.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyOf(@NotNull Permissible permissible, Permission ... permissions) {
        for (Permission permission : permissions) {
            if (!permissible.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyOfOrAdmin(@NotNull Permissible permissible, String ... permissions) {
        return permissible.isOp() || permissible.hasPermission("*") || Permissions.anyOf(permissible, permissions);
    }

    public static boolean anyOfOrAdmin(@NotNull Permissible permissible, Permission ... permissions) {
        return permissible.isOp() || permissible.hasPermission("*") || Permissions.anyOf(permissible, permissions);
    }

    public static boolean allOf(@NotNull Permissible permissible, String ... permissions) {
        for (String permission : permissions) {
            if (permissible.hasPermission(permission)) continue;
            return false;
        }
        return true;
    }

    public static boolean allOf(@NotNull Permissible permissible, Permission ... permissions) {
        for (Permission permission : permissions) {
            if (permissible.hasPermission(permission)) continue;
            return false;
        }
        return true;
    }
}

