/*
 * Decompiled with CFR 0.152.
 */
package net.wiicart.commands.tabcomplete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class TabCompleteUtil {
    public static final List<String> EMPTY = List.of();

    private TabCompleteUtil() {
    }

    @NotNull
    public static List<String> getOnlinePlayerNames() {
        Collection players = Bukkit.getOnlinePlayers();
        ArrayList<String> list = new ArrayList<String>(players.size());
        for (Player p : players) {
            list.add(p.getName());
        }
        return list;
    }

    @NotNull
    public static List<String> filter(@NotNull List<String> list, @NotNull String input) {
        return list.stream().filter(arg -> arg.toLowerCase().startsWith(input.toLowerCase())).toList();
    }

    @SafeVarargs
    @NotNull
    public static List<String> combine(Collection<String> ... collections) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (Collection<String> collection : collections) {
            set.addAll(collection);
        }
        return new ArrayList<String>(set);
    }

    @SafeVarargs
    @NotNull
    public static List<String> combine(@NotNull String string, Collection<String> ... collections) {
        List<String> list = TabCompleteUtil.combine(collections);
        if (!list.contains(string)) {
            list.add(string);
        }
        return list;
    }
}

