/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.datapack_utils;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1935;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3852;
import net.minecraft.server.MinecraftServer;
import org.rhm.datapack_utils.DatapackUtilsBase;
import org.rhm.datapack_utils.types.CompostableType;
import org.rhm.datapack_utils.types.CustomAnvilRecipe;
import org.rhm.datapack_utils.types.FuelType;
import org.rhm.datapack_utils.types.OffersType;

public class DatapackUtilsCommon {
    public static final String MOD_ID = "datapack_utils";
    public static DatapackUtilsBase impl;
    private static Set<FuelType> FUELS;
    private static Set<CompostableType> COMPOSTABLES;
    private static final Set<OffersType> OFFERS;
    public static final Set<CustomAnvilRecipe> ANVIL_RECIPES;

    public static void init() {
    }

    public static void reloadAll(MinecraftServer server) {
        class_3300 manager = server.method_34864();
        DatapackUtilsCommon.reloadFuels(manager);
        DatapackUtilsCommon.reloadCompostables(manager);
        DatapackUtilsCommon.reloadCustomTrades(manager);
        DatapackUtilsCommon.reloadAnvilRecipes(manager);
    }

    private static void reloadFuels(class_3300 manager) {
        HashSet<FuelType> temp = new HashSet<FuelType>();
        for (Map.Entry customFuels : manager.method_14488("utils", x -> x.method_12832().equalsIgnoreCase("utils/custom_fuels.json")).entrySet()) {
            class_3298 resource = (class_3298)customFuels.getValue();
            try {
                for (FuelType fuelType : (List)((Pair)FuelType.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.method_43039())).getOrThrow(false, string -> {})).getFirst()) {
                    temp.add(fuelType);
                    if (fuelType.tag().isPresent()) {
                        impl.registerFuel(fuelType.tag().get(), fuelType.duration());
                        continue;
                    }
                    if (!fuelType.item().isPresent()) continue;
                    impl.registerFuel((class_1935)fuelType.item().get(), fuelType.duration());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (FuelType fuelType : FUELS) {
            if (temp.contains(fuelType)) continue;
            if (fuelType.tag().isPresent()) {
                impl.unregisterFuel(fuelType.tag().get());
            }
            if (!fuelType.item().isPresent()) continue;
            impl.unregisterFuel((class_1935)fuelType.item().get());
        }
        FUELS = temp;
    }

    private static void reloadCompostables(class_3300 manager) {
        HashSet<CompostableType> temp = new HashSet<CompostableType>();
        for (Map.Entry customFuels : manager.method_14488("utils", x -> x.method_12832().equalsIgnoreCase("utils/custom_compostables.json")).entrySet()) {
            class_3298 resource = (class_3298)customFuels.getValue();
            try {
                for (CompostableType compostType : (List)((Pair)CompostableType.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.method_43039())).getOrThrow(false, string -> {})).getFirst()) {
                    temp.add(compostType);
                    if (compostType.tag().isPresent()) {
                        impl.registerCompostable(compostType.tag().get(), (float)compostType.chance() / 100.0f);
                        continue;
                    }
                    if (!compostType.item().isPresent()) continue;
                    impl.registerCompostable((class_1935)compostType.item().get(), (float)compostType.chance() / 100.0f);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (CompostableType compostType : COMPOSTABLES) {
            if (temp.contains(compostType)) continue;
            if (compostType.tag().isPresent()) {
                impl.unregisterCompostable(compostType.tag().get());
            }
            if (!compostType.item().isPresent()) continue;
            impl.unregisterCompostable((class_1935)compostType.item().get());
        }
        COMPOSTABLES = temp;
    }

    private static void reloadCustomTrades(class_3300 manager) {
        OFFERS.clear();
    }

    private static void reloadAnvilRecipes(class_3300 manager) {
        ANVIL_RECIPES.clear();
        for (Map.Entry customFuels : manager.method_14488("utils", x -> x.method_12832().startsWith("utils/anvil_recipe/") && x.method_12832().endsWith(".json")).entrySet()) {
            class_3298 resource = (class_3298)customFuels.getValue();
            try {
                ANVIL_RECIPES.add((CustomAnvilRecipe)((Pair)CustomAnvilRecipe.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.method_43039())).getOrThrow(false, string -> {})).getFirst());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Set<OffersType> getOffersForProfession(class_3852 profession) {
        return OFFERS.stream().filter(offer -> offer.profession() == profession).collect(Collectors.toSet());
    }

    static {
        FUELS = new HashSet<FuelType>();
        COMPOSTABLES = new HashSet<CompostableType>();
        OFFERS = new HashSet<OffersType>();
        ANVIL_RECIPES = new HashSet<CustomAnvilRecipe>();
    }
}

