/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.datapack_utils;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.ItemLike;
import org.rhm.datapack_utils.DatapackUtilsBase;
import org.rhm.datapack_utils.types.CompostableType;
import org.rhm.datapack_utils.types.CustomAnvilRecipe;
import org.rhm.datapack_utils.types.FuelType;
import org.rhm.datapack_utils.types.OffersType;

public class DatapackUtilsCommon {
    public static final String MOD_ID = "datapack_utils";
    public static DatapackUtilsBase impl;
    private static Set<FuelType> FUELS;
    private static Set<CompostableType> COMPOSTABLES;
    private static final Set<OffersType> OFFERS;
    public static final Set<CustomAnvilRecipe> ANVIL_RECIPES;

    public static void init() {
    }

    public static void reloadAll(MinecraftServer server) {
        ResourceManager manager = server.getResourceManager();
        DatapackUtilsCommon.reloadFuels(manager);
        DatapackUtilsCommon.reloadCompostables(manager);
        DatapackUtilsCommon.reloadCustomTrades(manager);
        DatapackUtilsCommon.reloadAnvilRecipes(manager);
    }

    private static void reloadFuels(ResourceManager manager) {
        HashSet<FuelType> temp = new HashSet<FuelType>();
        for (Map.Entry customFuels : manager.listResources("utils", x -> x.getPath().equalsIgnoreCase("utils/custom_fuels.json")).entrySet()) {
            Resource resource = (Resource)customFuels.getValue();
            try {
                for (FuelType fuelType : (List)((Pair)FuelType.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.openAsReader())).getOrThrow()).getFirst()) {
                    temp.add(fuelType);
                    if (fuelType.tag().isPresent()) {
                        impl.registerFuel(fuelType.tag().get(), fuelType.duration());
                        continue;
                    }
                    if (!fuelType.item().isPresent()) continue;
                    impl.registerFuel((ItemLike)fuelType.item().get(), fuelType.duration());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (FuelType fuelType : FUELS) {
            if (temp.contains(fuelType)) continue;
            if (fuelType.tag().isPresent()) {
                impl.unregisterFuel(fuelType.tag().get());
            }
            if (!fuelType.item().isPresent()) continue;
            impl.unregisterFuel((ItemLike)fuelType.item().get());
        }
        FUELS = temp;
    }

    private static void reloadCompostables(ResourceManager manager) {
        HashSet<CompostableType> temp = new HashSet<CompostableType>();
        for (Map.Entry customFuels : manager.listResources("utils", x -> x.getPath().equalsIgnoreCase("utils/custom_compostables.json")).entrySet()) {
            Resource resource = (Resource)customFuels.getValue();
            try {
                for (CompostableType compostType : (List)((Pair)CompostableType.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.openAsReader())).getOrThrow()).getFirst()) {
                    temp.add(compostType);
                    if (compostType.tag().isPresent()) {
                        impl.registerCompostable(compostType.tag().get(), (float)compostType.chance() / 100.0f);
                        continue;
                    }
                    if (!compostType.item().isPresent()) continue;
                    impl.registerCompostable((ItemLike)compostType.item().get(), (float)compostType.chance() / 100.0f);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (CompostableType compostType : COMPOSTABLES) {
            if (temp.contains(compostType)) continue;
            if (compostType.tag().isPresent()) {
                impl.unregisterCompostable(compostType.tag().get());
            }
            if (!compostType.item().isPresent()) continue;
            impl.unregisterCompostable((ItemLike)compostType.item().get());
        }
        COMPOSTABLES = temp;
    }

    private static void reloadCustomTrades(ResourceManager manager) {
        OFFERS.clear();
        for (Map.Entry customTrades : manager.listResources("utils", x -> x.getPath().equalsIgnoreCase("utils/custom_trades.json")).entrySet()) {
            Resource resource = (Resource)customTrades.getValue();
            try {
                OFFERS.addAll((Collection)((Pair)OffersType.CODEC.listOf().decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.openAsReader())).getOrThrow()).getFirst());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static void reloadAnvilRecipes(ResourceManager manager) {
        ANVIL_RECIPES.clear();
        for (Map.Entry customFuels : manager.listResources("utils", x -> x.getPath().startsWith("utils/anvil_recipe/") && x.getPath().endsWith(".json")).entrySet()) {
            Resource resource = (Resource)customFuels.getValue();
            try {
                ANVIL_RECIPES.add((CustomAnvilRecipe)((Pair)CustomAnvilRecipe.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resource.openAsReader())).getOrThrow()).getFirst());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static Set<OffersType> getOffersForProfession(VillagerProfession profession) {
        return OFFERS.stream().filter(offer -> offer.profession() == profession).collect(Collectors.toSet());
    }

    static {
        FUELS = new HashSet<FuelType>();
        COMPOSTABLES = new HashSet<CompostableType>();
        OFFERS = new HashSet<OffersType>();
        ANVIL_RECIPES = new HashSet<CustomAnvilRecipe>();
    }
}

