/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.datapack_utils.forge;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import org.rhm.datapack_utils.DatapackUtilsBase;

public class DatapackUtilsForgeImpl
implements DatapackUtilsBase {
    public static final Object2IntMap<ItemLike> FUELS = Object2IntMaps.emptyMap();

    @Override
    public void registerFuel(ItemLike item, int duration) {
        FUELS.put((Object)item, duration);
    }

    @Override
    public void registerFuel(TagKey<Item> tag, int duration) {
        this.forAllItemsInTag(tag, item -> FUELS.put(item, duration));
    }

    @Override
    public void unregisterFuel(ItemLike item) {
        FUELS.remove((Object)item);
    }

    @Override
    public void unregisterFuel(TagKey<Item> tag) {
        this.forAllItemsInTag(tag, arg_0 -> FUELS.remove(arg_0));
    }

    @Override
    public void registerCompostable(ItemLike item, float chance) {
        ComposterBlock.COMPOSTABLES.put((Object)item, chance);
    }

    @Override
    public void registerCompostable(TagKey<Item> tag, float chance) {
        this.forAllItemsInTag(tag, item -> ComposterBlock.COMPOSTABLES.put(item, chance));
    }

    @Override
    public void unregisterCompostable(ItemLike item) {
        ComposterBlock.COMPOSTABLES.remove((Object)item);
    }

    @Override
    public void unregisterCompostable(TagKey<Item> tag) {
        this.forAllItemsInTag(tag, arg_0 -> ((Object2FloatMap)ComposterBlock.COMPOSTABLES).remove(arg_0));
    }
}

