/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.datapack_utils.mixin;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.rhm.datapack_utils.DatapackUtilsCommon;
import org.rhm.datapack_utils.types.CustomAnvilRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot cost;
    @Shadow
    @Nullable
    private String itemName;

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess, ItemCombinerMenuSlotDefinition itemCombinerMenuSlotDefinition) {
        super(menuType, i, inventory, containerLevelAccess, itemCombinerMenuSlotDefinition);
    }

    @Inject(method={"createResult()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void createResult(CallbackInfo ci) {
        ItemStack input = this.inputSlots.getItem(0);
        ItemStack secondaryInput = this.inputSlots.getItem(1);
        if (!input.isEmpty()) {
            DatapackUtilsCommon.ANVIL_RECIPES.stream().filter(recipe -> AnvilMenuMixin.datapack_utils$matchesInput(recipe, input, secondaryInput)).findFirst().ifPresent(recipe -> {
                this.cost.set(recipe.cost());
                ItemStack result = recipe.output().copy();
                if (!recipe.ignoreName()) {
                    if (this.itemName != null && !StringUtil.isBlank((String)this.itemName)) {
                        if (!this.itemName.equals(input.getHoverName().getString())) {
                            result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                        }
                    } else {
                        result.remove(DataComponents.CUSTOM_NAME);
                    }
                }
                this.resultSlots.setItem(0, result);
                this.broadcastChanges();
                ci.cancel();
            });
        }
    }

    @Unique
    private static boolean datapack_utils$matchesInput(CustomAnvilRecipe recipe, ItemStack input, ItemStack secondaryInput) {
        return recipe.input().test(input) && recipe.secondaryInput().map(i -> i.test(secondaryInput)).orElse(true) != false;
    }
}

