/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.ars_lumos.dynamic;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.dadamalda.ars_lumos.Ars_lumos;
import net.dadamalda.ars_lumos.Config;
import net.dadamalda.ars_lumos.config.ResourcePack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public final class DynAssetPlanner {
    public static final AssetResourceCache ASSET_CACHE = (AssetResourceCache)ResourceCache.register((ResourceCache)new AssetResourceCache(ResourceLocation.fromNamespaceAndPath((String)"ars_lumos", (String)"dynamic")));
    public static final ResourceLocation EMPTY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"dynamic_asset_generator", (String)"textures/empty.png");
    public static final ResourceLocation EMISSIVE_PROPERTIES = ResourceLocation.parse((String)"minecraft:optifine/emissive.properties");
    public static Set<ResourceLocation> ASSETS = new HashSet<ResourceLocation>();
    public static Map<ResourceLocation, ResourceLocation> ASSET_MAP = new HashMap<ResourceLocation, ResourceLocation>();
    public static String resourcePack = "default";

    public static void plan() {
        ASSET_CACHE.planSource(new PathAwareInputStreamSource(){

            @NotNull
            public Set<ResourceLocation> getLocations(ResourceGenerationContext resourceGenerationContext) {
                block13: {
                    resourcePack = "default";
                    if (Config.resourcePack == ResourcePack.DETECT) {
                        try {
                            InputStream footprint = (InputStream)Objects.requireNonNull(resourceGenerationContext.getResourceSource().getResource(ResourceLocation.parse((String)"ars_nouveau:textures/block/blue_archwood_log.png"))).get();
                            InputStream loafersFootprint = (InputStream)Objects.requireNonNull(resourceGenerationContext.getResourceSource().getResource(ResourceLocation.fromNamespaceAndPath((String)"ars_lumos", (String)"textures/configurable/loafers/footprint.png"))).get();
                            if (IOUtils.contentEquals((InputStream)footprint, (InputStream)loafersFootprint)) {
                                resourcePack = "loafers";
                                Ars_lumos.LOGGER.info("Ars Loafers detected, if this is wrong, change the config");
                                break block13;
                            }
                            Ars_lumos.LOGGER.info("No supported resource pack detected, if this is wrong, change the config");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        resourcePack = Config.resourcePack.getVariantId();
                    }
                }
                ASSETS.clear();
                ASSETS.add(EMISSIVE_PROPERTIES);
                ASSET_MAP.clear();
                DynAssetPlanner.addWealdWalker("cascading", Config.enableCascading);
                DynAssetPlanner.addWealdWalker("flourishing", Config.enableFlourishing);
                DynAssetPlanner.addWealdWalker("vexing", Config.enableVexing);
                DynAssetPlanner.addWealdWalker("blazing", Config.enableBlazing);
                DynAssetPlanner.addWealdWalker("flashing", Config.enableFlashing);
                if (!Config.enableAll) {
                    return ASSETS;
                }
                if (Config.enableCascading) {
                    DynAssetPlanner.addArchwood(ResourceLocation.parse((String)"ars_nouveau:blue"), "cascading");
                }
                if (Config.enableFlourishing) {
                    DynAssetPlanner.addArchwood(ResourceLocation.parse((String)"ars_nouveau:green"), "flourishing");
                }
                if (Config.enableVexing) {
                    DynAssetPlanner.addArchwood(ResourceLocation.parse((String)"ars_nouveau:purple"), "vexing");
                }
                if (Config.enableBlazing) {
                    DynAssetPlanner.addArchwood(ResourceLocation.parse((String)"ars_nouveau:red"), "blazing");
                }
                if (Config.enableFlashing) {
                    DynAssetPlanner.addArchwood(ResourceLocation.parse((String)"ars_elemental:yellow"), "flashing", false);
                    DynAssetPlanner.addTexture(ResourceLocation.parse((String)"ars_elemental:textures/block/yellow_archwood_log_top_e"), resourcePack, !resourcePack.equals("loafers"));
                }
                if (Config.enableWarpPortals) {
                    DynAssetPlanner.addTexture(ResourceLocation.parse((String)"ars_nouveau:textures/block/warp_portal_e"), true);
                }
                if (Config.enableSourceJars) {
                    DynAssetPlanner.addTexture(ResourceLocation.parse((String)"ars_nouveau:textures/block/mana_still_e"), resourcePack, true);
                }
                return ASSETS;
            }

            @Nullable
            public IoSupplier<InputStream> get(ResourceLocation resourceLocation, ResourceGenerationContext resourceGenerationContext) {
                if (resourceLocation.equals((Object)EMISSIVE_PROPERTIES)) {
                    return () -> new ByteArrayInputStream("suffix.emissive=_e".getBytes(StandardCharsets.UTF_8));
                }
                return resourceGenerationContext.getResourceSource().getResource(ASSET_MAP.getOrDefault(resourceLocation, EMPTY_TEXTURE));
            }
        });
    }

    private static void addAsset(ResourceLocation output, ResourceLocation input) {
        ASSETS.add(output);
        ASSET_MAP.put(output, input);
    }

    private static void addTexture(ResourceLocation location, String variant, boolean hasMcmeta) {
        ResourceLocation input = ResourceLocation.fromNamespaceAndPath((String)"ars_lumos", (String)("textures/configurable/" + variant + "/" + location.getNamespace() + "/" + location.getPath()));
        DynAssetPlanner.addAsset(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(location.getPath() + ".png")), ResourceLocation.fromNamespaceAndPath((String)input.getNamespace(), (String)(input.getPath() + ".png")));
        if (hasMcmeta) {
            DynAssetPlanner.addAsset(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)(location.getPath() + ".png.mcmeta")), ResourceLocation.fromNamespaceAndPath((String)input.getNamespace(), (String)(input.getPath() + ".png.mcmeta")));
        }
    }

    private static void addTexture(ResourceLocation location, String variant) {
        DynAssetPlanner.addTexture(location, variant, false);
    }

    private static void addTexture(ResourceLocation location) {
        DynAssetPlanner.addTexture(location, "default", false);
    }

    private static void addTexture(ResourceLocation location, boolean hasMcmeta) {
        DynAssetPlanner.addTexture(location, "default", hasMcmeta);
    }

    private static void addArchwood(ResourceLocation typeColor, String typeName, boolean hasBark) {
        if (Config.enableLogs) {
            for (String permutation : List.of("", "_1", "_2", "_3")) {
                DynAssetPlanner.addTexture(typeColor.withPath("textures/block/" + typeColor.getPath() + "_archwood_log" + permutation + "_e"), resourcePack, !resourcePack.equals("loafers"));
            }
        }
        if (Config.enableBark && hasBark) {
            DynAssetPlanner.addTexture(ResourceLocation.fromNamespaceAndPath((String)"arsdelight", (String)("textures/item/ingredient/" + typeName + "_bark_e")));
        }
    }

    private static void addArchwood(ResourceLocation typeColor, String typeName) {
        DynAssetPlanner.addArchwood(typeColor, typeName, true);
    }

    private static void addWealdWalker(String typeName, boolean typeEnabled) {
        DynAssetPlanner.addTexture(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)("textures/entity/" + typeName + "_weald_walker_glowmask")), Config.enableAll && Config.enableWealdWalkers && typeEnabled ? "default" : "disabled");
        DynAssetPlanner.addTexture(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)("textures/entity/" + typeName + "_weald_waddler_glowmask")), Config.enableAll && Config.enableWealdWaddlers && typeEnabled ? "default" : "disabled");
    }
}

