/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bungee;

import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.SonarPlatform;
import xyz.jonesdev.sonar.api.logger.LoggerWrapper;
import xyz.jonesdev.sonar.bungee.SonarBungeePlugin;
import xyz.jonesdev.sonar.bungee.command.BungeeSonarCommand;
import xyz.jonesdev.sonar.bungee.fallback.FallbackBungeeInjector;
import xyz.jonesdev.sonar.common.boot.SonarBootstrap;
import xyz.jonesdev.sonar.libs.bstats.bungeecord.Metrics;
import xyz.jonesdev.sonar.libs.bstats.charts.SimplePie;
import xyz.jonesdev.sonar.libs.kyori.adventure.audience.Audience;
import xyz.jonesdev.sonar.libs.kyori.adventure.platform.bungeecord.BungeeAudiences;
import xyz.jonesdev.sonar.libs.libby.BungeeLibraryManager;

public final class SonarBungee
extends SonarBootstrap<SonarBungeePlugin> {
    private final BungeeAudiences bungeeAudiences = BungeeAudiences.create((Plugin)this.getPlugin());
    private final LoggerWrapper logger = new LoggerWrapper(){

        @Override
        public void info(String message, Object ... args) {
            ((SonarBungeePlugin)((Object)SonarBungee.this.getPlugin())).getLogger().info(this.buildFullMessage(message, args));
        }

        @Override
        public void warn(String message, Object ... args) {
            ((SonarBungeePlugin)((Object)SonarBungee.this.getPlugin())).getLogger().warning(this.buildFullMessage(message, args));
        }

        @Override
        public void error(String message, Object ... args) {
            ((SonarBungeePlugin)((Object)SonarBungee.this.getPlugin())).getLogger().severe(this.buildFullMessage(message, args));
        }
    };
    private Metrics metrics;

    public SonarBungee(@NotNull SonarBungeePlugin plugin) {
        super(plugin, SonarPlatform.BUNGEE, plugin.getDataFolder(), new BungeeLibraryManager(plugin));
    }

    @Override
    @Nullable
    public Audience audience(@Nullable UUID uniqueId) {
        if (uniqueId == null) {
            return null;
        }
        return this.bungeeAudiences.player(uniqueId);
    }

    @Override
    @NotNull
    public Audience sender(@NotNull Object object) {
        return this.bungeeAudiences.sender((CommandSender)object);
    }

    @Override
    public void enable() {
        this.logger.warn("The use of BungeeCord is supported but not condoned.", new Object[0]);
        this.logger.warn("Consider upgrading to Velocity (https://velocitypowered.com)", new Object[0]);
        this.metrics = new Metrics((Plugin)this.getPlugin(), this.getPlatform().getMetricsId());
        this.metrics.addCustomChart(new SimplePie("verification", () -> this.getConfig().getVerification().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("captcha", () -> this.getConfig().getVerification().getMap().getTiming().getDisplayName()));
        this.metrics.addCustomChart(new SimplePie("language", () -> this.getConfig().getLanguage().getName()));
        this.metrics.addCustomChart(new SimplePie("database_type", () -> this.getConfig().getDatabase().getType().getDisplayName()));
        ((SonarBungeePlugin)((Object)this.getPlugin())).getServer().getPluginManager().registerCommand((Plugin)this.getPlugin(), (Command)new BungeeSonarCommand());
        FallbackBungeeInjector.inject();
    }

    @Override
    public void disable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    public BungeeAudiences getBungeeAudiences() {
        return this.bungeeAudiences;
    }

    @Override
    public LoggerWrapper getLogger() {
        return this.logger;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

