/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.bungee.fallback;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.LoginRequest;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.fallback.FallbackInboundHandlerAdapter;
import xyz.jonesdev.sonar.common.util.exception.ReflectiveOperationException;

final class FallbackBungeeInboundHandler
extends FallbackInboundHandlerAdapter {
    private static final MethodHandle CHANNEL_WRAPPER_GETTER;

    FallbackBungeeInboundHandler() {
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof PacketWrapper) {
            PacketWrapper packetWrapper = (PacketWrapper)msg;
            DefinedPacket wrappedPacket = packetWrapper.packet;
            if (wrappedPacket != null) {
                if (wrappedPacket instanceof Handshake) {
                    Handshake handshake = (Handshake)wrappedPacket;
                    if (handshake.getRequestedProtocol() == 1) {
                        ctx.pipeline().remove((ChannelHandler)this);
                    } else {
                        this.handleHandshake(ctx, handshake.getHost(), handshake.getProtocolVersion());
                    }
                } else if (wrappedPacket instanceof LoginRequest) {
                    LoginRequest loginRequest = (LoginRequest)wrappedPacket;
                    HandlerBoss handlerBoss = (HandlerBoss)ctx.pipeline().get(HandlerBoss.class);
                    if (handlerBoss != null) {
                        ChannelWrapper channelWrapper;
                        try {
                            channelWrapper = CHANNEL_WRAPPER_GETTER.invokeExact(handlerBoss);
                        }
                        catch (Throwable throwable) {
                            throw new ReflectiveOperationException(throwable);
                        }
                        ctx.pipeline().remove((ChannelHandler)this);
                        packetWrapper.trySingleRelease();
                        InetSocketAddress socketAddress = (InetSocketAddress)channelWrapper.getRemoteAddress();
                        this.handleLogin(ctx, () -> ctx.fireChannelRead(msg), loginRequest.getData(), socketAddress);
                        return;
                    }
                }
            }
        }
        ctx.fireChannelRead(msg);
    }

    static {
        try {
            CHANNEL_WRAPPER_GETTER = MethodHandles.privateLookupIn(HandlerBoss.class, MethodHandles.lookup()).findGetter(HandlerBoss.class, "channel", ChannelWrapper.class);
        }
        catch (Exception exception) {
            throw new ReflectiveOperationException(exception);
        }
    }
}

