/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.captcha.legacy;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.libs.jhlabs.image.AbstractBufferedImageOp;

public final class ScratchFilter
extends AbstractBufferedImageOp {
    private static final Random RANDOM = new Random();
    private final int amount;

    @NotNull
    public BufferedImage filter(@NotNull BufferedImage src, BufferedImage dst) {
        Graphics2D graphics = src.createGraphics();
        Color color0 = Color.getHSBColor(RANDOM.nextFloat(), RANDOM.nextFloat(), 1.0f);
        Color color1 = new Color(~color0.getRGB());
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, color0, src.getWidth(), src.getHeight(), color1);
        graphics.setPaint(gradient);
        float halfWidth = (float)src.getWidth() * 0.5f;
        for (int i = 0; i < this.amount; ++i) {
            float randomX = (float)src.getWidth() * RANDOM.nextFloat();
            float randomY = (float)src.getHeight() * RANDOM.nextFloat();
            float amplitude = (float)Math.PI * 2 * (RANDOM.nextFloat() - 0.5f);
            float sin = (float)Math.sin(amplitude) * halfWidth;
            float cos = (float)Math.cos(amplitude) * halfWidth;
            float x1 = randomX - cos;
            float y1 = randomY - sin;
            float x2 = randomX + cos;
            float y2 = randomY + sin;
            graphics.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }
        graphics.dispose();
        return src;
    }

    public ScratchFilter(int amount) {
        this.amount = amount;
    }
}

