/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.api.fingerprint.FingerprintingUtil;
import xyz.jonesdev.sonar.common.fallback.FallbackBandwidthHandler;
import xyz.jonesdev.sonar.common.fallback.FallbackInboundHandler;
import xyz.jonesdev.sonar.common.fallback.FallbackUserWrapper;
import xyz.jonesdev.sonar.common.fallback.netty.FallbackTimeoutHandler;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketEncoder;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacketRegistry;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPreparer;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;
import xyz.jonesdev.sonar.common.util.GeyserUtil;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;
import xyz.jonesdev.sonar.common.util.exception.QuietDecoderException;

public abstract class FallbackInboundHandlerAdapter
extends ChannelInboundHandlerAdapter {
    @Nullable
    protected String username;
    protected ProtocolVersion protocolVersion;
    @Nullable
    protected RemovalListener channelRemovalListener;

    protected final void handleHandshake(@NotNull ChannelHandlerContext ctx, @NotNull String hostname, int protocol) throws Exception {
        if (hostname.isEmpty()) {
            throw QuietDecoderException.INSTANCE;
        }
        if (this.protocolVersion != null) {
            throw QuietDecoderException.INSTANCE;
        }
        this.protocolVersion = ProtocolVersion.fromId(protocol);
        ctx.pipeline().addFirst("sonar-bandwidth-counter", FallbackBandwidthHandler.INSTANCE);
    }

    protected final void handleLogin(@NotNull ChannelHandlerContext ctx, @NotNull Runnable initialLoginAction, @NotNull String username, @NotNull InetSocketAddress socketAddress) throws Exception {
        int score;
        GlobalSonarStatistics.countLogin();
        if (this.protocolVersion == null) {
            throw QuietDecoderException.INSTANCE;
        }
        if (this.protocolVersion.isUnknown()) {
            FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.unsupportedVersion, ProtocolVersion.MINECRAFT_1_7_2);
            return;
        }
        if (this.username != null) {
            throw QuietDecoderException.INSTANCE;
        }
        this.username = username;
        InetAddress inetAddress = socketAddress.getAddress();
        ((FallbackInboundHandler)ctx.pipeline().get(FallbackInboundHandler.class)).setInetAddress(inetAddress);
        if (Sonar.get0().getFallback().getConnected().containsKey(inetAddress)) {
            FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.alreadyVerifying, this.protocolVersion);
            return;
        }
        if (Sonar.get0().getConfig().getVerification().getBlacklistedProtocols().contains(this.protocolVersion.getProtocol())) {
            FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.protocolBlacklisted, this.protocolVersion);
            return;
        }
        String hostAddress = inetAddress.getHostAddress();
        int limit = Sonar.get0().getConfig().getVerification().getBlacklistThreshold();
        if (limit > 0 && (score = Sonar.get0().getFallback().getBlacklist().asMap().getOrDefault(hostAddress, 0).intValue()) >= limit) {
            FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.blacklisted, this.protocolVersion);
            return;
        }
        if (!Sonar.get0().getFallback().shouldVerifyNewPlayers()) {
            this.initialLogin(ctx.channel(), inetAddress, initialLoginAction);
            return;
        }
        boolean geyser = GeyserUtil.isGeyserConnection(ctx.channel(), socketAddress);
        if (geyser && !Sonar.get0().getConfig().getVerification().isCheckGeyser()) {
            this.initialLogin(ctx.channel(), inetAddress, initialLoginAction);
            return;
        }
        String fingerprint = FingerprintingUtil.getFingerprint(username, hostAddress);
        if (Sonar.get0().getVerifiedPlayerController().getCache().contains(fingerprint)) {
            this.initialLogin(ctx.channel(), inetAddress, initialLoginAction);
            return;
        }
        if (!Sonar.get0().getFallback().getRatelimiter().attempt(inetAddress)) {
            FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.reconnectedTooFast, this.protocolVersion);
            return;
        }
        FallbackInboundHandlerAdapter.rewriteProtocol(ctx, this.channelRemovalListener);
        Sonar.get0().getFallback().getQueue().getPlayers().compute(inetAddress, (__, runnable) -> {
            if (runnable != null) {
                FallbackInboundHandlerAdapter.customDisconnect(ctx.channel(), FallbackPreparer.alreadyQueued, this.protocolVersion);
                return null;
            }
            return () -> new FallbackUserWrapper(ctx, inetAddress, this.protocolVersion, username, fingerprint, geyser);
        });
    }

    protected final void initialLogin(@NotNull Channel channel, @NotNull InetAddress inetAddress, @NotNull Runnable loginPacket) throws Exception {
        int maxOnlinePerIp = Sonar.get0().getConfig().getMaxOnlinePerIp();
        int newCount = Sonar.get0().getFallback().getOnline().compute(inetAddress, (__, count) -> count == null ? 1 : count + 1);
        if (newCount > maxOnlinePerIp) {
            FallbackInboundHandlerAdapter.customDisconnect(channel, FallbackPreparer.tooManyOnlinePerIP, this.protocolVersion);
            return;
        }
        loginPacket.run();
    }

    private static void rewriteProtocol(@NotNull ChannelHandlerContext ctx, @Nullable RemovalListener removalListener) {
        for (Map.Entry entry : ctx.pipeline()) {
            if (((String)entry.getKey()).startsWith("sonar") || ((String)entry.getKey()).startsWith("geyser") || ((String)entry.getKey()).startsWith("floodgate") || ((String)entry.getKey()).equals("DefaultChannelPipeline$TailContext#0")) continue;
            ctx.pipeline().remove((ChannelHandler)entry.getValue());
            if (removalListener == null) continue;
            removalListener.accept(ctx.pipeline(), (String)entry.getKey(), (ChannelHandler)entry.getValue());
        }
        ctx.pipeline().addFirst("sonar-timeout", (ChannelHandler)new FallbackTimeoutHandler(Sonar.get0().getConfig().getVerification().getReadTimeout(), Sonar.get0().getConfig().getVerification().getWriteTimeout(), TimeUnit.MILLISECONDS));
    }

    private static void customDisconnect(@NotNull Channel channel, @NotNull FallbackPacket packet, @NotNull ProtocolVersion protocolVersion) {
        if (channel.isActive()) {
            if (channel.eventLoop().inEventLoop()) {
                FallbackInboundHandlerAdapter._customDisconnect(channel, packet, protocolVersion);
            } else {
                channel.eventLoop().execute(() -> FallbackInboundHandlerAdapter._customDisconnect(channel, packet, protocolVersion));
            }
        }
    }

    private static void _customDisconnect(@NotNull Channel channel, @NotNull FallbackPacket packet, @NotNull ProtocolVersion protocolVersion) {
        String handler = Sonar.get0().getPlatform().getConnectionHandler();
        if (channel.pipeline().context(handler) != null) {
            channel.pipeline().remove(handler);
        }
        String encoder = Sonar.get0().getPlatform().getEncoder().apply(channel.pipeline());
        ChannelHandler currentEncoder = channel.pipeline().get(encoder);
        if (currentEncoder != null) {
            if (!(currentEncoder instanceof FallbackPacketEncoder)) {
                FallbackPacketEncoder newEncoder = new FallbackPacketEncoder(protocolVersion);
                newEncoder.updateRegistry(FallbackPacketRegistry.LOGIN);
                channel.pipeline().replace(encoder, "sonar-packet-encoder", (ChannelHandler)newEncoder);
            }
            ProtocolUtil.closeWith(channel, protocolVersion, packet);
        } else {
            channel.close();
        }
    }

    public FallbackInboundHandlerAdapter(@Nullable String username, ProtocolVersion protocolVersion, @Nullable RemovalListener channelRemovalListener) {
        this.username = username;
        this.protocolVersion = protocolVersion;
        this.channelRemovalListener = channelRemovalListener;
    }

    public FallbackInboundHandlerAdapter() {
    }

    @FunctionalInterface
    public static interface RemovalListener {
        public void accept(@NotNull ChannelPipeline var1, @NotNull String var2, @NotNull ChannelHandler var3);
    }
}

