/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.block;

import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.common.fallback.protocol.block.BlockType;

public final class BlockUpdate {
    private final BlockPosition position;
    private final BlockType blockType;
    private final int legacyBlockState;
    private final int blockState;

    public BlockUpdate(@NotNull BlockPosition position, BlockType blockType) {
        this.position = position;
        this.blockType = blockType;
        int x = position.getX() - (position.getChunkX() << 4);
        int y = position.getY();
        int z = position.getZ() - (position.getChunkZ() << 4);
        this.legacyBlockState = x << 12 | z << 8 | y;
        this.blockState = x << 8 | z << 4 | y - (y >> 4 << 4);
    }

    public BlockPosition getPosition() {
        return this.position;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public int getLegacyBlockState() {
        return this.legacyBlockState;
    }

    public int getBlockState() {
        return this.blockState;
    }

    public static final class BlockPosition {
        private final int x;
        private final int y;
        private final int z;
        private final int chunkX;
        private final int chunkZ;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public int getChunkX() {
            return this.chunkX;
        }

        public int getChunkZ() {
            return this.chunkZ;
        }

        public BlockPosition(int x, int y, int z, int chunkX, int chunkZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
        }
    }
}

