/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SetDefaultSpawnPositionPacket
implements FallbackPacket {
    private String dimensionName;
    private int x;
    private int y;
    private int z;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.writeInt(this.x);
            byteBuf.writeInt(this.y);
            byteBuf.writeInt(this.z);
        } else {
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_9)) {
                ProtocolUtil.writeString(byteBuf, this.dimensionName);
            }
            long encoded = protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_14) ? ((long)this.x & 0x3FFFFFFL) << 38 | ((long)this.y & 0xFFFL) << 26 | (long)this.z & 0x3FFFFFFL : ((long)this.x & 0x3FFFFFFL) << 38 | ((long)this.y & 0x3FFFFFFL) << 12 | (long)this.z & 0xFFFL;
            byteBuf.writeLong(encoded);
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17)) {
                byteBuf.writeFloat(0.0f);
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_9)) {
                    byteBuf.writeFloat(0.0f);
                }
            }
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "SetDefaultSpawnPositionPacket(dimensionName=" + this.getDimensionName() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    public SetDefaultSpawnPositionPacket() {
    }

    public SetDefaultSpawnPositionPacket(String dimensionName, int x, int y, int z) {
        this.dimensionName = dimensionName;
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

