/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SetPlayerPositionRotationPacket
implements FallbackPacket {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private int teleportId;
    private int relativeMask;
    private boolean onGround;
    private boolean horizontalCollision;
    private boolean dismountVehicle;

    @Override
    public void encode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        boolean v1_21_2 = protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_2);
        if (v1_21_2) {
            ProtocolUtil.writeVarInt(byteBuf, this.teleportId);
        }
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_8) ? this.y : this.y + (double)1.62f);
        byteBuf.writeDouble(this.z);
        if (v1_21_2) {
            byteBuf.writeDouble(0.0);
            byteBuf.writeDouble(0.0);
            byteBuf.writeDouble(0.0);
            byteBuf.writeFloat(this.yaw);
            byteBuf.writeFloat(this.pitch);
            byteBuf.writeInt(this.relativeMask);
        } else {
            byteBuf.writeFloat(this.yaw);
            byteBuf.writeFloat(this.pitch);
            byteBuf.writeByte(this.relativeMask);
        }
        if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_8)) {
            if (!v1_21_2) {
                ProtocolUtil.writeVarInt(byteBuf, this.teleportId);
            }
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_17) && protocolVersion.lessThanOrEquals(ProtocolVersion.MINECRAFT_1_19_3)) {
                byteBuf.writeBoolean(this.dismountVehicle);
            }
        }
    }

    @Override
    public void decode(@NotNull ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            byteBuf.readDouble();
        }
        this.z = byteBuf.readDouble();
        this.yaw = byteBuf.readFloat();
        this.pitch = byteBuf.readFloat();
        if (protocolVersion.greaterThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            short flag = byteBuf.readUnsignedByte();
            this.onGround = (flag & 1) != 0;
            this.horizontalCollision = (flag & 2) != 0;
        } else {
            this.onGround = byteBuf.readBoolean();
        }
    }

    @Override
    public int expectedMaxLength(@NotNull ProtocolVersion protocolVersion) {
        return protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8) ? 41 : 33;
    }

    @Override
    public int expectedMinLength(ProtocolVersion protocolVersion) {
        return 33;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public int getTeleportId() {
        return this.teleportId;
    }

    public int getRelativeMask() {
        return this.relativeMask;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public boolean isDismountVehicle() {
        return this.dismountVehicle;
    }

    public String toString() {
        return "SetPlayerPositionRotationPacket(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", teleportId=" + this.getTeleportId() + ", relativeMask=" + this.getRelativeMask() + ", onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ", dismountVehicle=" + this.isDismountVehicle() + ")";
    }

    public SetPlayerPositionRotationPacket() {
    }

    public SetPlayerPositionRotationPacket(double x, double y, double z, float yaw, float pitch, int teleportId, int relativeMask, boolean onGround, boolean horizontalCollision, boolean dismountVehicle) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.teleportId = teleportId;
        this.relativeMask = relativeMask;
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
        this.dismountVehicle = dismountVehicle;
    }
}

