/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.entity.EntityType;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class SpawnEntityPacket
implements FallbackPacket {
    private int entityId;
    private EntityType entityType;
    private double x;
    private double y;
    private double z;
    private int data;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        ProtocolUtil.writeVarInt(byteBuf, this.entityId);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9)) {
            ProtocolUtil.writeUUID(byteBuf, UUID.randomUUID());
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_14)) {
            ProtocolUtil.writeVarInt(byteBuf, this.entityType.getId().apply(protocolVersion));
        } else {
            byteBuf.writeByte(this.entityType.getId().apply(protocolVersion).intValue());
        }
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9)) {
            byteBuf.writeDouble(this.x);
            byteBuf.writeDouble(this.y);
            byteBuf.writeDouble(this.z);
            if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_21_9)) {
                SpawnEntityPacket.encodeVelocity(byteBuf, this.velocityX, this.velocityY, this.velocityZ);
            }
        } else {
            byteBuf.writeInt((int)(this.x * 32.0));
            byteBuf.writeInt((int)(this.y * 32.0));
            byteBuf.writeInt((int)(this.z * 32.0));
        }
        byteBuf.writeByte(0);
        byteBuf.writeByte(0);
        if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_19)) {
            byteBuf.writeByte(0);
            ProtocolUtil.writeVarInt(byteBuf, this.data);
        } else {
            byteBuf.writeInt(this.data);
        }
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_21_9) && (this.data > 0 || protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_9))) {
            byteBuf.writeShort((int)(this.velocityX * 8000.0));
            byteBuf.writeShort((int)(this.velocityY * 8000.0));
            byteBuf.writeShort((int)(this.velocityZ * 8000.0));
        }
    }

    private static void encodeVelocity(ByteBuf byteBuf, double x, double y, double z) {
        double maxVal = Math.max(Math.abs(x), Math.max(Math.abs(y), Math.abs(z)));
        if (maxVal < 3.051944088384301E-5) {
            byteBuf.writeByte(0);
            return;
        }
        long scale = (long)Math.ceil(maxVal);
        boolean scaleTooLargeForBits = (scale & 3L) != scale;
        long scaleBits = scaleTooLargeForBits ? scale & 3L | 4L : scale;
        long encodedX = SpawnEntityPacket.packLpVec3Component(x / (double)scale) << 3;
        long encodedY = SpawnEntityPacket.packLpVec3Component(y / (double)scale) << 18;
        long encodedZ = SpawnEntityPacket.packLpVec3Component(z / (double)scale) << 33;
        long packed = scaleBits | encodedX | encodedY | encodedZ;
        byteBuf.writeByte((int)((byte)packed));
        byteBuf.writeByte((int)((byte)(packed >> 8)));
        byteBuf.writeInt((int)(packed >> 16));
        if (scaleTooLargeForBits) {
            ProtocolUtil.writeVarInt(byteBuf, (int)(scale >> 2));
        }
    }

    private static long packLpVec3Component(double d) {
        return Math.round((d * 0.5 + 0.5) * 32766.0);
    }

    @Override
    public void decode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getEntityId() {
        return this.entityId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public int getData() {
        return this.data;
    }

    public double getVelocityX() {
        return this.velocityX;
    }

    public double getVelocityY() {
        return this.velocityY;
    }

    public double getVelocityZ() {
        return this.velocityZ;
    }

    public String toString() {
        return "SpawnEntityPacket(entityId=" + this.getEntityId() + ", entityType=" + String.valueOf((Object)this.getEntityType()) + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", data=" + this.getData() + ", velocityX=" + this.getVelocityX() + ", velocityY=" + this.getVelocityY() + ", velocityZ=" + this.getVelocityZ() + ")";
    }

    public SpawnEntityPacket() {
    }

    public SpawnEntityPacket(int entityId, EntityType entityType, double x, double y, double z, int data, double velocityX, double velocityY, double velocityZ) {
        this.entityId = entityId;
        this.entityType = entityType;
        this.x = x;
        this.y = y;
        this.z = z;
        this.data = data;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
    }
}

