/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.protocol.packets.play;

import io.netty.buffer.ByteBuf;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.protocol.ProtocolVersion;
import xyz.jonesdev.sonar.common.fallback.protocol.FallbackPacket;
import xyz.jonesdev.sonar.common.fallback.protocol.block.BlockUpdate;
import xyz.jonesdev.sonar.common.util.ProtocolUtil;

public final class UpdateSectionBlocksPacket
implements FallbackPacket {
    private int sectionX;
    private int sectionZ;
    private BlockUpdate[] blockUpdates;

    @Override
    public void encode(ByteBuf byteBuf, @NotNull ProtocolVersion protocolVersion) throws Exception {
        if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_16_2)) {
            byteBuf.writeInt(this.sectionX);
            byteBuf.writeInt(this.sectionZ);
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                byteBuf.writeShort(this.blockUpdates.length);
                byteBuf.writeInt(4 * this.blockUpdates.length);
            } else {
                ProtocolUtil.writeVarInt(byteBuf, this.blockUpdates.length);
            }
            for (BlockUpdate block : this.blockUpdates) {
                byteBuf.writeShort(block.getLegacyBlockState());
                int blockId = block.getBlockType().getId().apply(protocolVersion);
                if (protocolVersion.greaterThanOrEquals(ProtocolVersion.MINECRAFT_1_13)) {
                    ProtocolUtil.writeVarInt(byteBuf, blockId);
                    continue;
                }
                int shiftedBlockId = blockId << 4;
                if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_8)) {
                    byteBuf.writeShort(shiftedBlockId);
                    continue;
                }
                ProtocolUtil.writeVarInt(byteBuf, shiftedBlockId);
            }
        } else {
            int sectionY = this.blockUpdates[0].getPosition().getY() >> 4;
            byteBuf.writeLong(((long)this.sectionX & 0x3FFFFFL) << 42 | (long)(sectionY & 0xFFFFF) | ((long)this.sectionZ & 0x3FFFFFL) << 20);
            if (protocolVersion.lessThan(ProtocolVersion.MINECRAFT_1_20)) {
                byteBuf.writeBoolean(true);
            }
            ProtocolUtil.writeVarInt(byteBuf, this.blockUpdates.length);
            for (BlockUpdate block : this.blockUpdates) {
                int shiftedBlockId = block.getBlockType().getId().apply(protocolVersion) << 12;
                long positionIdValue = shiftedBlockId | block.getBlockState();
                ProtocolUtil.writeVarLong(byteBuf, positionIdValue);
            }
        }
    }

    @Override
    public void decode(ByteBuf byteBuf, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException();
    }

    public int getSectionX() {
        return this.sectionX;
    }

    public int getSectionZ() {
        return this.sectionZ;
    }

    public BlockUpdate[] getBlockUpdates() {
        return this.blockUpdates;
    }

    public UpdateSectionBlocksPacket() {
    }

    public UpdateSectionBlocksPacket(int sectionX, int sectionZ, BlockUpdate[] blockUpdates) {
        this.sectionX = sectionX;
        this.sectionZ = sectionZ;
        this.blockUpdates = blockUpdates;
    }

    public String toString() {
        return "UpdateSectionBlocksPacket(sectionX=" + this.getSectionX() + ", sectionZ=" + this.getSectionZ() + ")";
    }
}

