/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.fallback.ratelimit;

import java.net.InetAddress;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.fallback.ratelimit.Ratelimiter;
import xyz.jonesdev.sonar.libs.caffeine.cache.Cache;
import xyz.jonesdev.sonar.libs.caffeine.cache.Caffeine;
import xyz.jonesdev.sonar.libs.caffeine.cache.Ticker;

public final class CaffeineCacheRatelimiter
implements Ratelimiter<InetAddress> {
    private long timeout;
    private Cache<InetAddress, Long> expiringCache;

    public CaffeineCacheRatelimiter(@NotNull Duration duration) {
        this.timeout = duration.toNanos();
        this.expiringCache = Caffeine.newBuilder().ticker(Ticker.systemTicker()).expireAfterWrite(duration).build();
    }

    @Override
    public boolean attempt(@NotNull InetAddress inetAddress) {
        long last;
        long expectedNewTimestamp = System.nanoTime() + this.timeout;
        return expectedNewTimestamp == (last = ((Long)this.expiringCache.get((Object)inetAddress, result -> expectedNewTimestamp)).longValue());
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setExpiringCache(Cache<InetAddress, Long> expiringCache) {
        this.expiringCache = expiringCache;
    }

    public CaffeineCacheRatelimiter() {
    }
}

