/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.service;

import java.sql.SQLException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.config.SonarConfiguration;
import xyz.jonesdev.sonar.api.update.UpdateChecker;
import xyz.jonesdev.sonar.common.statistics.GlobalSonarStatistics;

public final class ScheduledServiceManager {
    private static final ScheduledExecutorService VERBOSE = ScheduledServiceManager.createScheduledExecutor("sonar-verbose-thread");
    private static final ScheduledExecutorService DB_CLEANUP = ScheduledServiceManager.createScheduledExecutor("sonar-db-cleanup-thread");
    private static final ScheduledExecutorService FALLBACK_QUEUE = ScheduledServiceManager.createScheduledExecutor("sonar-queue-thread");
    private static final ScheduledExecutorService STATISTICS = ScheduledServiceManager.createScheduledExecutor("sonar-statistics-thread");
    private static final ScheduledExecutorService UPDATE_NOTIFIER = ScheduledServiceManager.createScheduledExecutor("sonar-update-notifier");

    @NotNull
    private static ScheduledExecutorService createScheduledExecutor(String threadName) {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName(threadName);
            thread.setDaemon(true);
            return thread;
        });
    }

    public static void start() {
        if (Sonar.get0().getVerifiedPlayerController().getCachedDatabaseType() != SonarConfiguration.Database.Type.NONE) {
            DB_CLEANUP.scheduleAtFixedRate(() -> {
                try {
                    Sonar.get0().getVerifiedPlayerController().clearOld(Sonar.get0().getVerifiedPlayerController().getMaximumAge(), true);
                }
                catch (SQLException exception) {
                    Sonar.get0().getLogger().error("Error cleaning database entries!", new Object[0]);
                    exception.printStackTrace(System.err);
                }
            }, Sonar.get0().getVerifiedPlayerController().getMaximumAge(), 1L, TimeUnit.DAYS);
        }
        VERBOSE.scheduleAtFixedRate(() -> {
            GlobalSonarStatistics.cleanUpCaches();
            Sonar.get0().getFallback().getBlacklist().cleanUp();
            Sonar.get0().getAttackTracker().checkIfUnderAttack();
            Sonar.get0().getActionBarNotificationHandler().handleNotification();
        }, 0L, 250L, TimeUnit.MILLISECONDS);
        FALLBACK_QUEUE.scheduleAtFixedRate(() -> Sonar.get0().getFallback().getQueue().poll(), 1L, 1L, TimeUnit.SECONDS);
        STATISTICS.scheduleAtFixedRate(GlobalSonarStatistics::hitEverySecond, 0L, 1L, TimeUnit.SECONDS);
        if (Sonar.get0().getConfig().getGeneralConfig().getBoolean("general.check-for-updates")) {
            UPDATE_NOTIFIER.scheduleAtFixedRate(UpdateChecker::checkForUpdates, 0L, 2L, TimeUnit.HOURS);
        }
    }

    public static void stop() {
        DB_CLEANUP.shutdown();
        VERBOSE.shutdown();
        FALLBACK_QUEUE.shutdown();
        STATISTICS.shutdown();
        UPDATE_NOTIFIER.shutdown();
    }

    private ScheduledServiceManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

