/*
 * Decompiled with CFR 0.152.
 */
package xyz.jonesdev.sonar.common.statistics;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import xyz.jonesdev.sonar.api.Sonar;
import xyz.jonesdev.sonar.api.profiler.SimpleProcessProfiler;
import xyz.jonesdev.sonar.api.statistics.SonarStatistics;
import xyz.jonesdev.sonar.libs.caffeine.cache.Cache;
import xyz.jonesdev.sonar.libs.caffeine.cache.Caffeine;
import xyz.jonesdev.sonar.libs.caffeine.cache.Ticker;

public final class GlobalSonarStatistics
implements SonarStatistics {
    private static final Cache<Integer, Byte> LOGINS_PER_SECOND = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).ticker(Ticker.systemTicker()).build();
    private static final Cache<Integer, Byte> CONNECTIONS_PER_SECOND = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).ticker(Ticker.systemTicker()).build();
    private static final AtomicInteger ACTION_COUNTER = new AtomicInteger(Integer.MIN_VALUE);
    private static int totalJoinedPlayers;
    public static int totalSuccessfulVerifications;
    public static int totalFailedVerifications;
    public static int totalAttemptedVerifications;
    public static long totalBlacklistedPlayers;
    public static long totalIncomingTraffic;
    public static long totalOutgoingTraffic;
    public static long perSecondIncomingTraffic;
    public static long perSecondOutgoingTraffic;
    private static String perSecondIncomingTrafficFormatted;
    private static String perSecondOutgoingTrafficFormatted;

    @ApiStatus.Internal
    public static void countConnection() {
        CONNECTIONS_PER_SECOND.put((Object)ACTION_COUNTER.getAndIncrement(), (Object)0);
    }

    @ApiStatus.Internal
    public static void countLogin() {
        LOGINS_PER_SECOND.put((Object)ACTION_COUNTER.getAndIncrement(), (Object)0);
        ++totalJoinedPlayers;
    }

    public static void cleanUpCaches() {
        LOGINS_PER_SECOND.cleanUp();
        CONNECTIONS_PER_SECOND.cleanUp();
    }

    public static void hitEverySecond() {
        totalIncomingTraffic += perSecondIncomingTraffic;
        totalOutgoingTraffic += perSecondOutgoingTraffic;
        perSecondIncomingTrafficFormatted = SimpleProcessProfiler.formatMemory(perSecondIncomingTraffic);
        perSecondOutgoingTrafficFormatted = SimpleProcessProfiler.formatMemory(perSecondOutgoingTraffic);
        perSecondIncomingTraffic = 0L;
        perSecondOutgoingTraffic = 0L;
    }

    @Override
    public long getConnectionsPerSecond() {
        return CONNECTIONS_PER_SECOND.estimatedSize();
    }

    @Override
    public long getLoginsPerSecond() {
        return LOGINS_PER_SECOND.estimatedSize();
    }

    @Override
    public long getCurrentIncomingBandwidth() {
        return perSecondIncomingTraffic;
    }

    @Override
    public long getCurrentOutgoingBandwidth() {
        return perSecondOutgoingTraffic;
    }

    @Override
    public long getTotalIncomingBandwidth() {
        return totalIncomingTraffic;
    }

    @Override
    public long getTotalOutgoingBandwidth() {
        return totalOutgoingTraffic;
    }

    @Override
    public String getPerSecondIncomingBandwidthFormatted() {
        return perSecondIncomingTrafficFormatted;
    }

    @Override
    public String getPerSecondOutgoingBandwidthFormatted() {
        return perSecondOutgoingTrafficFormatted;
    }

    @Override
    public int getTotalPlayersJoined() {
        return totalJoinedPlayers;
    }

    @Override
    public int getTotalPlayersVerified() {
        return Sonar.get0().getVerifiedPlayerController().getCache().size();
    }

    @Override
    public int getTotalSuccessfulVerifications() {
        return totalSuccessfulVerifications;
    }

    @Override
    public int getTotalFailedVerifications() {
        return totalFailedVerifications;
    }

    @Override
    public long getCurrentAttemptedVerifications() {
        return Sonar.get0().getFallback().getConnected().size();
    }

    @Override
    public int getTotalAttemptedVerifications() {
        return totalAttemptedVerifications;
    }

    @Override
    public long getCurrentBlacklistSize() {
        return Sonar.get0().getFallback().getBlacklist().estimatedSize();
    }

    @Override
    public long getTotalBlacklistSize() {
        return totalBlacklistedPlayers;
    }
}

